package com.getmati.mati_sdk.ui.utils

import android.util.Size
import java.util.*

/**
 * Compares two `Size`s based on their areas.
 */
internal class AreaComparator : Comparator<Size> {
    override fun compare(lhs: Size, rhs: Size): Int {
        // We cast here to ensure the multiplications won't overflow
        return java.lang.Long.signum(lhs.width.toLong() * lhs.height -
                rhs.width.toLong() * rhs.height)
    }
}