package com.getmati.mati_sdk.ui.utils

import android.net.Uri
import android.webkit.MimeTypeMap
import androidx.activity.result.ActivityResultLauncher
import androidx.fragment.app.Fragment
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import java.io.File
import java.io.FileNotFoundException

internal interface ImagePicker {
    val itemPickResultLauncher: ActivityResultLauncher<String>
}

internal fun <T> T.pickImage() where T : Fragment, T : ImagePicker {
    itemPickResultLauncher.launch("image/*")
}

internal interface PhotoCapture {
    var latestTmpUri: Uri?
    val takePhotoResultLauncher: ActivityResultLauncher<Uri>
}

internal fun <T> T.takePhotoWithOtherApp() where T : Fragment, T : PhotoCapture {
    context?.let{
        latestTmpUri = it.createTempFileUri()
        takePhotoResultLauncher.launch(latestTmpUri)
    }
}

internal suspend fun <T> T.copyContentToCache(selectedUri: Uri): File? where T : Fragment, T : ImagePicker =
    withContext(Dispatchers.IO) {
        try {
            val context = requireContext()
            context.contentResolver.openInputStream(selectedUri)?.use {
                val type = context.contentResolver.getType(selectedUri)
                val extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(type)
                val file =
                    File(context.cacheDir.path + "/${System.currentTimeMillis()}_temp_image.$extension")
                file.writeBytes(it.readBytes())
                file
            }
        } catch (e: FileNotFoundException) {
            null
        }
    }
