package com.getmati.mati_sdk.ui.utils

import android.content.Context
import com.getmati.mati_sdk.managers.shared_pref.SharedPreferenceManager
import com.getmati.mati_sdk.models.clean.Language
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject
import java.util.*

internal object LocaleManager : KoinComponent {

    private val sharedPreferenceManager by inject<SharedPreferenceManager>()

    fun setLocale(c: Context): Context {
        return updateResources(c, getLanguageId())
    }

    fun setNewLocale(c: Context, language: String): Context {
        persistLanguage(language)
        return updateResources(c, language)
    }

    fun getLanguageId() = sharedPreferenceManager.language

    fun getLanguage() = Language.fromId(getLanguageId()) ?: Language.ENGLISH

    fun persistLanguage(language: String) {
        sharedPreferenceManager.language = language
    }

    private fun updateResources(context: Context, language: String): Context {
        val locale = Locale(language)
        val config = context.resources.configuration
        config.setLocale(locale)
        return context.createConfigurationContext(config)
    }
}