package com.getmati.mati_sdk.ui.utils

import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import androidx.core.app.ActivityCompat

fun Context.hasPermission(permisison: String): Boolean {
    return (Build.VERSION.SDK_INT < Build.VERSION_CODES.M || ActivityCompat.checkSelfPermission(this, permisison) == PackageManager.PERMISSION_GRANTED)
}