package com.getmati.mati_sdk.ui.utils

import android.os.SystemClock
import android.view.View

internal abstract class SingleClickListener(private val freezePeriod: Int = 1000) : View.OnClickListener {
    private var mLastClickTime: Long = 0
    override fun onClick(view: View) {
        if (SystemClock.elapsedRealtime() - mLastClickTime < freezePeriod) return
        mLastClickTime = SystemClock.elapsedRealtime()
        onSingleClick(view)
    }

    abstract fun onSingleClick(view: View)
}