package com.getmati.mati_sdk.ui.utils

import android.graphics.PorterDuff
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.annotation.IdRes
import androidx.core.content.ContextCompat
import androidx.core.view.get
import androidx.fragment.app.Fragment
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.ui.data_prefetch.model.Config

internal fun <T : View> Fragment.findView(@IdRes id: Int): T {
    return this.requireView().findViewById(id)
}

internal fun View.setUpMainActionButton(config: Config?) {
    background?.setColorFilter(
        config?.buttonColor ?: ContextCompat.getColor(
            context,
            R.color.matiColorAccent
        ), PorterDuff.Mode.SRC_OVER
    )
    when (this) {
        is TextView -> setTextColor(
            config?.buttonTextColor ?: ContextCompat.getColor(
                context,
                R.color.matiPrimaryTextInverse
            )
        )
        is ImageView -> setColorFilter(
            config?.buttonTextColor ?: ContextCompat.getColor(
                context,
                R.color.matiPrimaryTextInverse
            )
        )
    }
}

internal fun ViewGroup.findPrimaries(): List<View> {
    val result = mutableListOf<View>()
    (0 until this.childCount).forEach {
        this[it].let { child ->
            if (child.tag == "primary")
                result.add(child)
            if (child is ViewGroup) {
                result.addAll(child.findPrimaries())
            }
        }
    }
    return result
}