package com.getmati.mati_sdk.ui.utils

import android.content.ActivityNotFoundException
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.Color
import android.os.Build
import android.util.TypedValue
import android.webkit.MimeTypeMap
import android.webkit.WebSettings
import android.widget.Toast
import androidx.core.content.FileProvider
import com.getmati.mati_sdk.BuildConfig
import java.io.File


internal object Util {
    fun getMimeTime(path: String): String? {
        return MimeTypeMap.getFileExtensionFromUrl(path)?.let {
            MimeTypeMap.getSingleton().getMimeTypeFromExtension(it)
        }
    }

    @JvmStatic
    fun dpToPx(context: Context, dp: Float): Int {
        return TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_DIP, dp, context.resources.displayMetrics).toInt()
    }

    fun isColorDark(hex: String?): Boolean {
        val color: Int
        color = try {
            Color.parseColor(hex)
        } catch (pE: IllegalArgumentException) {
            pE.printStackTrace()
            return false
        }
        val darkness = (0.299 * Color.red(color) + 0.587 * Color.green(color) + 0.114 * Color.blue(color)) / 255
        return darkness < 0.58
    }

    @JvmStatic
    fun getUserAgent(context: Context): String {
        WebSettings.getDefaultUserAgent(context)
        return String.format("%s %s; Mati SDK %s; %s/%s; Android %s",
                getApplicationName(context), getApplicationVersion(context),
                BuildConfig.VERSION_NAME, Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE
        )
    }

    @JvmStatic
    fun openPdf(context: Context, filePath: String) {
        val data = FileProvider.getUriForFile(
            context,
            "${context.applicationContext.packageName}.provider",
            File(filePath)
        )

        val intent = Intent(Intent.ACTION_VIEW)
        intent.setDataAndType(data, "application/pdf")
        intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP
        intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY)

        try {
            context.startActivity(intent)
        } catch (e: ActivityNotFoundException) {
            Toast.makeText(context, "Download an App to open PDF", Toast.LENGTH_LONG)
                .show()
        }
    }

    private fun getApplicationName(context: Context): String {
        val applicationInfo = context.applicationInfo
        val stringId = applicationInfo.labelRes
        return if (stringId == 0) applicationInfo.nonLocalizedLabel.toString() else context.getString(stringId)
    }

    private fun getApplicationVersion(context: Context): String {
        return try {
            val packageInfo = context.packageManager.getPackageInfo(
                    context.packageName, 0
            )
            val versionName = packageInfo.versionName
            val versionCode: Int
            versionCode = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                packageInfo.longVersionCode.toInt()
            } else {
                packageInfo.versionCode
            }
            String.format("%s (%s)", versionName, versionCode)
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
            ""
        }
    }
}