package com.getmati.mati_sdk.ui.verification

import android.content.Context
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.checkDiskSpace
import com.getmati.mati_sdk.managers.AppComponentRegistry
import com.getmati.mati_sdk.mati_navigation.MatiNavigation
import com.getmati.mati_sdk.ui.error.BaseErrorFragment
import com.getmati.mati_sdk.ui.error.prepareMediaErrorScreenData
import com.getmati.mati_sdk.ui.utils.LocaleManager
import com.getmati.mati_sdk.widgets.MatiToolbar
import org.koin.androidx.viewmodel.ext.android.viewModel
import org.koin.core.context.GlobalContext

internal class VerificationActivity : AppCompatActivity(R.layout.activity_kyc) {

    private val appInitializerManager = AppComponentRegistry()

    val verificationVm: VerificationVm by viewModel()
    val navigation by lazy { MatiNavigation(this, verificationVm, this) }
    val toolbar: MatiToolbar by lazy { findViewById(R.id.toolbar) }

    override fun attachBaseContext(newBase: Context) {
        val isRegistered = GlobalContext.getOrNull() != null
        if (!isRegistered) {
            appInitializerManager.registerComponents(newBase.applicationContext)
        }
        val locale = LocaleManager.setLocale(newBase)
        super.attachBaseContext(locale)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        toolbar.setCloseImageVisibile(false)
        toolbar.setChooseLanguageVisible(false)
        toolbar.setBackImageVisibile(false)
    }

    override fun onDestroy() {
        if (isFinishing) {
            appInitializerManager.unRegisterComponents()
        }
        super.onDestroy()
    }

    fun handleFullDiskSpaceOrElse(requiredBytes: Long = MIN_REQUIRED_BYTES_FOR_VIDEO, action: () -> Unit) {
        checkDiskSpace(requiredBytes) { enoughDiskSpace ->
            if (enoughDiskSpace) {
                action()
            } else {
                navigation.navigateTo(
                    BaseErrorFragment.destination(prepareMediaErrorScreenData(
                        icon = R.drawable.ic_disk_space,
                        title = getString(R.string.label_out_of_space_error_title),
                        subHeading = getString(R.string.label_out_of_space_error_description),
                        primaryCTALabel = getString(R.string.label_try_again)
                    )
                    )
                )
            }
        }
    }
    companion object {
        internal const val MIN_REQUIRED_BYTES_FOR_VIDEO = 1024 * 1024 * 150L; //150 MB
    }
}
