package com.getmati.mati_sdk.ui.web

import android.util.Log
import android.webkit.JavascriptInterface
import com.getmati.mati_sdk.analytics.events.*
import com.getmati.mati_sdk.analytics.track

internal class AndroidBridge(
    private val webCallback: WebVerificationVm.WebCallback,
    private val verificationType: String
) {
    @JavascriptInterface
    fun postMessage(messageType: String, payload: String?) {
        when (messageType) {
            JsToAndroidMessageType.HANDSHAKE.value -> {
                webCallback.onHandShake()
                track(
                    WebVerificationEvent(
                        verificationType,
                        Started(),
                    )
                )
            }
            JsToAndroidMessageType.CLOSE.value -> {
                webCallback.onSuccess()
            }
            JsToAndroidMessageType.INTERRUPT.value -> {
                webCallback.onInterrupt()
            }
            JsToAndroidMessageType.ERROR.value -> {
                webCallback.onFailure()
                track(
                    WebVerificationEvent(
                        verificationType,
                        Failed("OTHER", "$payload", 0),
                    )
                )
            }
            JsToAndroidMessageType.SKIP.value -> {
                webCallback.onSkip()
                track(
                    WebVerificationEvent(
                        verificationType,
                        Skipped(),
                    )
                )
            }
        }
    }
}

enum class JsToAndroidMessageType(val value: String) {
    HANDSHAKE("Handshake"),
    CLOSE("Close"),
    ERROR("Error"),
    SUCCESS("Success"),
    FAILURE("Failure"),
    SKIP("Skip"),
    INTERRUPT("Interrupt")
}