package com.getmati.mati_sdk.widgets

import android.content.Context
import android.util.AttributeSet
import com.getmati.mati_sdk.R

internal object PassCodeViewStyleUtils {

    private var defaultStyle: PassCodeView.Style? = null

    fun getDefault(context: Context): PassCodeView.Style {
        if (defaultStyle == null) {
            val resources = context.resources
            val symbolViewStyle = SymbolView.Style(
                    width = resources.getDimensionPixelSize(R.dimen.symbol_view_width),
                    height = resources.getDimensionPixelSize(R.dimen.symbol_view_height),
                    backgroundColor = context.getThemeColor(R.attr.colorSurface),
                    borderColor = context.getThemeColor(R.attr.colorPrimary),
                    borderWidth = resources.getDimensionPixelSize(R.dimen.symbol_view_stroke_width),
                    borderCornerRadius = resources.getDimension(R.dimen.symbol_view_corner_radius),
                    textColor = context.getThemeColor(R.attr.colorOnSurface),
                    textSize = resources.getDimensionPixelSize(R.dimen.symbol_view_text_size),
                    fontFamily = R.font.lato_regular
            )
            defaultStyle = PassCodeView.Style(
                    codeLength = PassCodeView.DEFAULT_CODE_LENGTH,
                    symbolsSpacing = resources.getDimensionPixelSize(R.dimen.symbols_spacing),
                    symbolViewStyle = symbolViewStyle
            )
        }
        return defaultStyle!!
    }

    fun getFromAttributes(
            attrs: AttributeSet,
            context: Context
    ): PassCodeView.Style {

        val defaultStyle = getDefault(context)
        val defaultSymbolStyle = defaultStyle.symbolViewStyle
        val typedArray =
                context.theme.obtainStyledAttributes(attrs, R.styleable.PassCodeView, 0, 0)
        return with(typedArray) {
            val symbolWidth = getDimensionPixelSize(
                    R.styleable.PassCodeView_symbol_width,
                    defaultSymbolStyle.width
            )
            val symbolHeight = getDimensionPixelSize(
                    R.styleable.PassCodeView_symbol_height,
                    defaultSymbolStyle.height
            )
            val symbolBackgroundColor = getColor(
                    R.styleable.PassCodeView_symbol_background_color,
                    defaultSymbolStyle.backgroundColor
            )
            val symbolBorderColor = getColor(
                    R.styleable.PassCodeView_symbol_border_color,
                    defaultSymbolStyle.borderColor
            )
            val symbolBorderWidth = getDimensionPixelSize(
                    R.styleable.PassCodeView_symbol_border_width,
                    defaultSymbolStyle.borderWidth
            )
            val symbolTextColor = getColor(
                    R.styleable.PassCodeView_symbol_text_color,
                    defaultSymbolStyle.textColor
            )
            val symbolTextSize = getDimensionPixelSize(
                    R.styleable.PassCodeView_symbol_text_size,
                    defaultSymbolStyle.textSize
            )

            val symbolFontFamily = getResourceId(
                    R.styleable.PassCodeView_symbol_font_family,
                    defaultSymbolStyle.fontFamily
            )

            val cornerRadius = getDimension(
                    R.styleable.PassCodeView_symbol_border_corner_radius,
                    defaultSymbolStyle.borderCornerRadius
            )

            val codeLength = getInt(
                    R.styleable.PassCodeView_pass_code_length,
                    defaultStyle.codeLength
            )
            val symbolsSpacingPx = getDimensionPixelSize(
                    R.styleable.PassCodeView_symbols_spacing,
                    defaultStyle.symbolsSpacing
            )

            recycle()

            PassCodeView.Style(
                    codeLength = codeLength,
                    symbolsSpacing = symbolsSpacingPx,
                    symbolViewStyle = SymbolView.Style(
                            width = symbolWidth,
                            height = symbolHeight,
                            backgroundColor = symbolBackgroundColor,
                            borderColor = symbolBorderColor,
                            borderWidth = symbolBorderWidth,
                            borderCornerRadius = cornerRadius,
                            textColor = symbolTextColor,
                            textSize = symbolTextSize,
                            fontFamily = symbolFontFamily
                    )
            )
        }
    }
}