package com.getmati.mati_sdk.widgets

import android.content.Context
import android.graphics.Canvas
import android.graphics.Path
import android.graphics.SurfaceTexture
import android.media.MediaPlayer
import android.net.Uri
import android.util.AttributeSet
import android.view.Surface
import android.view.TextureView
import android.widget.FrameLayout
import kotlin.math.min

internal class RoundVideoView : FrameLayout {
    private val textureView = TextureView(context)

    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        textureView.layoutParams =
            LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT)
        addView(textureView)
    }

    private val centerX by lazy { width / 2f }
    private val centerY by lazy { height / 2f }
    private val radius by lazy { min(centerX, centerY) }

    private val shapePath by lazy {
        Path().apply {
            addCircle(centerX, centerY, radius, Path.Direction.CW)
        }
    }

    override fun dispatchDraw(canvas: Canvas) {
        canvas.clipPath(shapePath)
        super.dispatchDraw(canvas)
    }

    fun playLooping(uri: Uri, loop: Boolean = true, volume: Float = 0f) {
        textureView.surfaceTextureListener = object : TextureView.SurfaceTextureListener {

            private var mediaPlayer: MediaPlayer? = null

            override fun onSurfaceTextureAvailable(
                surface: SurfaceTexture,
                width: Int,
                height: Int
            ) {
                mediaPlayer = MediaPlayer().apply {
                    setVolume(volume, volume)
                    setSurface(Surface(surface))
                    setDataSource(context, uri)
                    setOnPreparedListener {
                        it.isLooping = loop
                        it.start()
                    }
                    prepare()
                }
            }

            override fun onSurfaceTextureSizeChanged(
                surface: SurfaceTexture,
                width: Int,
                height: Int
            ) {
            }

            override fun onSurfaceTextureDestroyed(surface: SurfaceTexture): Boolean {
                mediaPlayer?.stop()
                mediaPlayer?.release()
                return true
            }

            override fun onSurfaceTextureUpdated(surface: SurfaceTexture) {

            }
        }
    }
}