package com.getmati.mati_sdk.widgets

import android.content.Context
import android.text.Editable
import android.text.SpannableString
import android.text.TextWatcher
import android.text.style.UnderlineSpan
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatTextView

class UnderlineTextView @JvmOverloads constructor(
        context: Context,
        attrs: AttributeSet? = null,
        defStyle: Int = 0
) : AppCompatTextView(context, attrs, defStyle) {

    private var processing = false
    var underline = true

    init {
        addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {}

            override fun afterTextChanged(s: Editable?) {
                if (processing) return
                underlineText()
            }
        })
        underlineText()
    }

    private fun underlineText() {
        if (processing || !underline) return
        processing = true
        val content = SpannableString(text)
        content.setSpan(UnderlineSpan(), 0, content.length, 0)
        text = content
        processing = false
    }
}