package com.getmati.mati_sdk.widgets

import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.util.AttributeSet
import android.view.View
import com.getmati.mati_sdk.ui.utils.Util.dpToPx
import kotlin.math.min

internal const val STROKE_WIDTH = 2000f

internal class VideoOverlay : View {
    constructor(context: Context?) : super(context!!)
    constructor(context: Context?, attrs: AttributeSet?) : super(context!!, attrs)
    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(context!!, attrs, defStyleAttr)

    val cx by lazy { width / 2f }
    val cy by lazy { 2f * height / 5f } // Somewhat fragile
    val radius by lazy { min(cx, cy) - dpToPx(context, 48f) + STROKE_WIDTH / 2f }

    private val paint = Paint().apply {
        color = Color.argb(0xA0,   0x23, 0x29, 0x39)
        style = Paint.Style.STROKE
        strokeWidth = STROKE_WIDTH
    }

    override fun dispatchDraw(canvas: Canvas) {
        canvas.drawCircle(cx, cy, radius, paint)
        super.dispatchDraw(canvas)
    }
}