package com.getmati.mati_sdk.widgets.pdf_component

import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import com.getmati.mati_sdk.R
import com.github.barteksc.pdfviewer.PDFView
import java.io.File

class PdfComponent(context: Context, attributeSet: AttributeSet) :
    FrameLayout(context, attributeSet) {

    private var lastPageBody: () -> Unit = {}
    private var pdfView: PDFView

    init {
        inflate(context, R.layout.pdf_view, this)
        pdfView = findViewById(R.id.pdfView)
    }

    fun setFilePath(filePath: String) {
        pdfView.fromFile(File(filePath))
            .swipeHorizontal(false)
            .onPageChange { page, pageCount ->
                if ((page + 1) == pageCount) {
                    lastPageBody()
                }
            }
            .load()
    }

    fun onLastPageReached(lastPageBody: () -> Unit) {
        this.lastPageBody = lastPageBody
    }
}