/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.storage.StorageManager;
import android.util.Patterns;
import android.view.TextureView;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a,\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u000fH\u0080\b\u00f8\u0001\u0000\u001a\f\u0010\u0010\u001a\u00020\n*\u00020\fH\u0000\u001a\f\u0010\u0011\u001a\u00020\n*\u00020\fH\u0000\u001a\f\u0010\u0012\u001a\u00020\n*\u00020\u0013H\u0000\u001a*\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u000fH\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"blink", "", "Landroid/view/View;", "duration", "", "centerCropMirrored", "Landroid/view/TextureView;", "mp", "Landroid/media/MediaPlayer;", "mirrored", "", "checkDiskSpace", "Landroid/content/Context;", "requiredBytes", "action", "Lkotlin/Function1;", "hasAudioPermission", "hasCameraPermission", "isValidEmail", "", "setSingleClickListener", "freezePeriod", "listener", "mati-sdk_release"})
public final class ExtensionsKt {
    public static final void checkDiskSpace(@NotNull Context $this$checkDiskSpace, long requiredBytes, @NotNull Function1<? super Boolean, Unit> action) {
        boolean bl;
        int $i$f$checkDiskSpace = 0;
        Intrinsics.checkNotNullParameter((Object)$this$checkDiskSpace, (String)"$this$checkDiskSpace");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (Build.VERSION.SDK_INT >= 26) {
            Context context = $this$checkDiskSpace.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            Context $this$getSystemService$iv = context;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv, StorageManager.class);
            Intrinsics.checkNotNull((Object)object);
            StorageManager storageManager = (StorageManager)object;
            UUID uUID = storageManager.getUuidForPath($this$checkDiskSpace.getCacheDir());
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"storageManager.getUuidForPath(cacheDir)");
            UUID appSpecificInternalDirUuid = uUID;
            long availableBytes = storageManager.getAllocatableBytes(appSpecificInternalDirUuid);
            if (availableBytes >= requiredBytes) {
                bl = true;
            } else {
                boolean bl2;
                try {
                    storageManager.allocateBytes(appSpecificInternalDirUuid, requiredBytes);
                    bl2 = true;
                }
                catch (IOException e) {
                    bl2 = false;
                }
                bl = bl2;
            }
        } else {
            File file = $this$checkDiskSpace.getCacheDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"cacheDir");
            StatFs statFs = new StatFs(file.getPath());
            bl = statFs.getAvailableBytes() >= requiredBytes;
        }
        boolean available = bl;
        action.invoke((Object)available);
    }

    /*
     * WARNING - void declaration
     */
    public static final void setSingleClickListener(@NotNull View $this$setSingleClickListener, long freezePeriod, @NotNull Function1<? super View, Unit> listener) {
        void mLastClickTime;
        Intrinsics.checkNotNullParameter((Object)$this$setSingleClickListener, (String)"$this$setSingleClickListener");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        $this$setSingleClickListener.setOnClickListener(new View.OnClickListener(freezePeriod, (Ref.LongRef)mLastClickTime, listener){
            final /* synthetic */ long $freezePeriod;
            final /* synthetic */ Ref.LongRef $mLastClickTime;
            final /* synthetic */ Function1 $listener;

            public final void onClick(View it) {
                if (SystemClock.elapsedRealtime() - this.$mLastClickTime.element > this.$freezePeriod) {
                    this.$mLastClickTime.element = SystemClock.elapsedRealtime();
                    View view = it;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"it");
                    this.$listener.invoke((Object)view);
                }
            }
            {
                this.$freezePeriod = l;
                this.$mLastClickTime = longRef;
                this.$listener = function1;
            }
        });
    }

    public static /* synthetic */ void setSingleClickListener$default(View view, long l, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1000L;
        }
        ExtensionsKt.setSingleClickListener(view, l, (Function1<? super View, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public static final void blink(@NotNull View $this$blink, long duration) {
        void it;
        Intrinsics.checkNotNullParameter((Object)$this$blink, (String)"$this$blink");
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        boolean bl = false;
        boolean bl2 = false;
        AlphaAnimation alphaAnimation2 = alphaAnimation;
        View view = $this$blink;
        boolean bl3 = false;
        it.setDuration(duration);
        it.setStartOffset(20L);
        it.setRepeatMode(2);
        it.setRepeatCount(-1);
        Unit unit = Unit.INSTANCE;
        view.startAnimation((Animation)alphaAnimation);
    }

    public static final boolean hasCameraPermission(@NotNull Context $this$hasCameraPermission) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCameraPermission, (String)"$this$hasCameraPermission");
        return Build.VERSION.SDK_INT < 23 || ActivityCompat.checkSelfPermission((Context)$this$hasCameraPermission, (String)"android.permission.CAMERA") == 0;
    }

    public static final boolean hasAudioPermission(@NotNull Context $this$hasAudioPermission) {
        Intrinsics.checkNotNullParameter((Object)$this$hasAudioPermission, (String)"$this$hasAudioPermission");
        return ActivityCompat.checkSelfPermission((Context)$this$hasAudioPermission, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    public static final boolean isValidEmail(@NotNull String $this$isValidEmail) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidEmail, (String)"$this$isValidEmail");
        CharSequence charSequence = $this$isValidEmail;
        boolean bl = false;
        return charSequence.length() > 0 && Patterns.EMAIL_ADDRESS.matcher($this$isValidEmail).matches();
    }

    public static final void centerCropMirrored(@NotNull TextureView $this$centerCropMirrored, @NotNull MediaPlayer mp, boolean mirrored) {
        Intrinsics.checkNotNullParameter((Object)$this$centerCropMirrored, (String)"$this$centerCropMirrored");
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        float horizontalMirroringFactor = mirrored ? -1.0f : 1.0f;
        float videoRatio = (float)mp.getVideoWidth() / (float)mp.getVideoHeight();
        float screenRatio = (float)$this$centerCropMirrored.getWidth() / (float)$this$centerCropMirrored.getHeight();
        float scaleXValue = videoRatio / screenRatio;
        if (scaleXValue >= 1.0f) {
            $this$centerCropMirrored.setScaleX(horizontalMirroringFactor * scaleXValue);
        } else {
            $this$centerCropMirrored.setScaleY(1.0f / scaleXValue);
            $this$centerCropMirrored.setScaleX(horizontalMirroringFactor);
        }
    }
}

