/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.adapters;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;
import com.getmati.mati_sdk.R;
import com.getmati.mati_sdk.analytics.AnalyticsKt;
import com.getmati.mati_sdk.analytics.events.Selected;
import com.getmati.mati_sdk.analytics.events.UserAction;
import com.getmati.mati_sdk.models.clean.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u001c\u0010\u0017\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/getmati/mati_sdk/adapters/LanguageAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/getmati/mati_sdk/adapters/LanguageAdapter$LanguageViewHolder;", "selectedLanguageId", "", "radioButtonColor", "", "(Ljava/lang/String;I)V", "languages", "", "Lcom/getmati/mati_sdk/models/clean/Language;", "[Lcom/getmati/mati_sdk/models/clean/Language;", "getRadioButtonColor", "()I", "getSelectedLanguageId", "()Ljava/lang/String;", "setSelectedLanguageId", "(Ljava/lang/String;)V", "getItemCount", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "viewGroup", "Landroid/view/ViewGroup;", "viewType", "LanguageViewHolder", "mati-sdk_release"})
public final class LanguageAdapter
extends RecyclerView.Adapter<LanguageViewHolder> {
    private final Language[] languages;
    @NotNull
    private String selectedLanguageId;
    private final int radioButtonColor;

    @NotNull
    public LanguageViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int viewType) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_language, viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"LayoutInflater.from(view\u2026nguage, viewGroup, false)");
        return new LanguageViewHolder(view);
    }

    public void onBindViewHolder(@NotNull LanguageViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Language language = this.languages[position];
        holder.bind(language, Intrinsics.areEqual((Object)language.getId(), (Object)this.selectedLanguageId));
        View view = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
        view.setTag((Object)language.getId());
        holder.itemView.setOnClickListener(new View.OnClickListener(this, language){
            final /* synthetic */ LanguageAdapter this$0;
            final /* synthetic */ Language $language;

            public final void onClick(View it) {
                AnalyticsKt.track(new UserAction("languageSelector", new Selected(this.$language.getId()), "languageSelect"));
                this.this$0.setSelectedLanguageId(this.$language.getId());
                this.this$0.notifyDataSetChanged();
            }
            {
                this.this$0 = languageAdapter;
                this.$language = language;
            }
        });
    }

    public int getItemCount() {
        return this.languages.length;
    }

    @NotNull
    public final String getSelectedLanguageId() {
        return this.selectedLanguageId;
    }

    public final void setSelectedLanguageId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.selectedLanguageId = string2;
    }

    public final int getRadioButtonColor() {
        return this.radioButtonColor;
    }

    public LanguageAdapter(@NotNull String selectedLanguageId, @ColorInt int radioButtonColor) {
        Intrinsics.checkNotNullParameter((Object)selectedLanguageId, (String)"selectedLanguageId");
        this.selectedLanguageId = selectedLanguageId;
        this.radioButtonColor = radioButtonColor;
        this.languages = Language.values();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/getmati/mati_sdk/adapters/LanguageAdapter$LanguageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/getmati/mati_sdk/adapters/LanguageAdapter;Landroid/view/View;)V", "languageLabel", "Landroid/widget/TextView;", "radioButton", "Landroid/widget/RadioButton;", "bind", "", "language", "Lcom/getmati/mati_sdk/models/clean/Language;", "isSelected", "", "mati-sdk_release"})
    public final class LanguageViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView languageLabel;
        private final RadioButton radioButton;

        public final void bind(@NotNull Language language, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            View view = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            this.languageLabel.setText((CharSequence)view.getContext().getString(language.getTitleRes()));
            this.radioButton.setButtonTintList(ColorStateList.valueOf((int)LanguageAdapter.this.getRadioButtonColor()));
            this.radioButton.setChecked(isSelected);
            View view2 = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView");
            view2.setSelected(isSelected);
        }

        public LanguageViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.label_language);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.label_language)");
            this.languageLabel = (TextView)view;
            View view2 = itemView.findViewById(R.id.radioButton);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.radioButton)");
            this.radioButton = (RadioButton)view2;
        }
    }
}

