/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.analytics;

import com.getmati.mati_sdk.analytics.Analytics;
import com.getmati.mati_sdk.analytics.WSTracker;
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder;
import com.getmati.mati_sdk.managers.shared_pref.SharedPreferenceManager;
import com.getmati.mati_sdk.ui.data_prefetch.model.Config;
import com.getmati.mati_sdk.ui.utils.LocaleManager;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/getmati/mati_sdk/analytics/AnalyticsRegistry;", "", "sharedPreferenceManager", "Lcom/getmati/mati_sdk/managers/shared_pref/SharedPreferenceManager;", "prefetchDataHolder", "Lcom/getmati/mati_sdk/managers/prefetch/PrefetchDataHolder;", "analytics", "Lcom/getmati/mati_sdk/analytics/Analytics;", "(Lcom/getmati/mati_sdk/managers/shared_pref/SharedPreferenceManager;Lcom/getmati/mati_sdk/managers/prefetch/PrefetchDataHolder;Lcom/getmati/mati_sdk/analytics/Analytics;)V", "initAnalytics", "", "mati-sdk_release"})
public final class AnalyticsRegistry {
    private final SharedPreferenceManager sharedPreferenceManager;
    private final PrefetchDataHolder prefetchDataHolder;
    private final Analytics analytics;

    public final void initAnalytics() {
        Config config = this.prefetchDataHolder.getConfig();
        String merchantId = this.prefetchDataHolder.getVerificationFlow().getId();
        String verificationId2 = this.prefetchDataHolder.getPrefetchedData().getVerificationId();
        if (!this.sharedPreferenceManager.getShouldShowAnalyticsDialogs()) {
            String deviceUUID = this.sharedPreferenceManager.deviceUUID();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            String string2 = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().language");
            List trackers = CollectionsKt.listOf((Object)new WSTracker(config, merchantId, verificationId2, string2, LocaleManager.INSTANCE.getLanguageId(), deviceUUID));
            this.analytics.setTrackers(trackers);
        }
    }

    public AnalyticsRegistry(@NotNull SharedPreferenceManager sharedPreferenceManager, @NotNull PrefetchDataHolder prefetchDataHolder, @NotNull Analytics analytics) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferenceManager, (String)"sharedPreferenceManager");
        Intrinsics.checkNotNullParameter((Object)prefetchDataHolder, (String)"prefetchDataHolder");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        this.sharedPreferenceManager = sharedPreferenceManager;
        this.prefetchDataHolder = prefetchDataHolder;
        this.analytics = analytics;
    }
}

