/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.mati_navigation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import androidx.core.os.BundleKt;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import com.getmati.mati_sdk.R;
import com.getmati.mati_sdk.analytics.AnalyticsKt;
import com.getmati.mati_sdk.analytics.events.BiometryUploadEvent;
import com.getmati.mati_sdk.analytics.events.Started;
import com.getmati.mati_sdk.analytics.events.Verification;
import com.getmati.mati_sdk.analytics.events.VerificationCanceled;
import com.getmati.mati_sdk.analytics.events.VerificationPassed;
import com.getmati.mati_sdk.analytics.events.VerificationStarted;
import com.getmati.mati_sdk.analytics.events.VerificationState;
import com.getmati.mati_sdk.mati_navigation.MatiDestination;
import com.getmati.mati_sdk.mati_navigation.MatiNavigation$WhenMappings;
import com.getmati.mati_sdk.models.clean.Country;
import com.getmati.mati_sdk.models.clean.CustomDoc;
import com.getmati.mati_sdk.models.clean.DocPage;
import com.getmati.mati_sdk.models.clean.Document;
import com.getmati.mati_sdk.models.clean.input.Input;
import com.getmati.mati_sdk.models.clean.input.InputError;
import com.getmati.mati_sdk.models.clean.verification.VerificationFlow;
import com.getmati.mati_sdk.models.clean.verification.VerificationFlowKt;
import com.getmati.mati_sdk.ui.BiometryUpload;
import com.getmati.mati_sdk.ui.DocumentVerificationStep;
import com.getmati.mati_sdk.ui.ESignVerificationStep;
import com.getmati.mati_sdk.ui.EmailVerification;
import com.getmati.mati_sdk.ui.SmsUpload;
import com.getmati.mati_sdk.ui.VerificationStep;
import com.getmati.mati_sdk.ui.WebVerificationStep;
import com.getmati.mati_sdk.ui.common.ExitFragment;
import com.getmati.mati_sdk.ui.common.VerificationSuccessFragment;
import com.getmati.mati_sdk.ui.doc_hint.DocumentHintFragment;
import com.getmati.mati_sdk.ui.document.CountriesRepo;
import com.getmati.mati_sdk.ui.document.SelectCountryFragment;
import com.getmati.mati_sdk.ui.document.SelectDocumentFragment;
import com.getmati.mati_sdk.ui.email.email_submission.EmailSubmissionFragment;
import com.getmati.mati_sdk.ui.esign.ESignHostFragment;
import com.getmati.mati_sdk.ui.iprestrictions.IpCountryRestrictedFragment;
import com.getmati.mati_sdk.ui.iprestrictions.VpnDetectedFragment;
import com.getmati.mati_sdk.ui.liveness.LivenessFragment;
import com.getmati.mati_sdk.ui.liveness.VoiceLivenessFragment;
import com.getmati.mati_sdk.ui.phonevalidation.PhoneInputFragment;
import com.getmati.mati_sdk.ui.selfie.SelfieHintFragment;
import com.getmati.mati_sdk.ui.verification.VerificationActivity;
import com.getmati.mati_sdk.ui.verification.VerificationVm;
import com.getmati.mati_sdk.ui.web.WebVerificationFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020'J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0013H\u0002J\u000e\u00100\u001a\u00020'2\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u00020'J\u000e\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020\u0013J\b\u00106\u001a\u000207H\u0016J\u0006\u00108\u001a\u00020'R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006:"}, d2={"Lcom/getmati/mati_sdk/mati_navigation/MatiNavigation;", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "Lorg/koin/core/component/KoinComponent;", "activity", "Lcom/getmati/mati_sdk/ui/verification/VerificationActivity;", "verificationVm", "Lcom/getmati/mati_sdk/ui/verification/VerificationVm;", "registryOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "(Lcom/getmati/mati_sdk/ui/verification/VerificationActivity;Lcom/getmati/mati_sdk/ui/verification/VerificationVm;Landroidx/savedstate/SavedStateRegistryOwner;)V", "getActivity", "()Lcom/getmati/mati_sdk/ui/verification/VerificationActivity;", "countriesRepo", "Lcom/getmati/mati_sdk/ui/document/CountriesRepo;", "getCountriesRepo", "()Lcom/getmati/mati_sdk/ui/document/CountriesRepo;", "countriesRepo$delegate", "Lkotlin/Lazy;", "currentVerificationStepIdx", "", "navController", "Landroidx/navigation/NavController;", "getNavController", "()Landroidx/navigation/NavController;", "navController$delegate", "restrictionError", "Lcom/getmati/mati_sdk/models/clean/input/InputError;", "getRestrictionError", "()Lcom/getmati/mati_sdk/models/clean/input/InputError;", "supportedCountries", "", "Lcom/getmati/mati_sdk/models/clean/Country;", "verificationFlow", "Lcom/getmati/mati_sdk/models/clean/verification/VerificationFlow;", "getVerificationFlow", "()Lcom/getmati/mati_sdk/models/clean/verification/VerificationFlow;", "getVerificationVm", "()Lcom/getmati/mati_sdk/ui/verification/VerificationVm;", "back", "", "cancelVerification", "checkPermission", "", "permission", "", "finishVerification", "finishWithResult", "result", "navigateTo", "destination", "Lcom/getmati/mati_sdk/mati_navigation/MatiDestination;", "openNextStep", "openVerificationStep", "verificationStepIdx", "saveState", "Landroid/os/Bundle;", "startVerification", "Companion", "mati-sdk_release"})
public final class MatiNavigation
implements SavedStateRegistry.SavedStateProvider,
KoinComponent {
    private final Lazy countriesRepo$delegate;
    private int currentVerificationStepIdx;
    private final Lazy navController$delegate;
    private final List<Country> supportedCountries;
    @NotNull
    private final VerificationActivity activity;
    @NotNull
    private final VerificationVm verificationVm;
    private final SavedStateRegistryOwner registryOwner;
    private static final String PROVIDER = "MatiNavigation";
    private static final String ARG_VERIFICATION_STEP_IDX = "ARG_VERIFICATION_STEP_IDX";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final CountriesRepo getCountriesRepo() {
        Lazy lazy = this.countriesRepo$delegate;
        MatiNavigation matiNavigation = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CountriesRepo)lazy.getValue();
    }

    private final VerificationFlow getVerificationFlow() {
        return this.verificationVm.getVerificationFlow();
    }

    private final InputError getRestrictionError() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)this.verificationVm.getInputsFlow().getValue();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Input it = (Input)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"connection-data")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Input input = v0;
        return input != null ? input.getError() : null;
    }

    public final boolean checkPermission(@NotNull String permission2) {
        Intrinsics.checkNotNullParameter((Object)permission2, (String)"permission");
        return Build.VERSION.SDK_INT > 23 && ActivityCompat.checkSelfPermission((Context)((Context)this.activity), (String)permission2) == 0;
    }

    private final NavController getNavController() {
        Lazy lazy = this.navController$delegate;
        MatiNavigation matiNavigation = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NavController)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void startVerification() {
        Collection<List> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = VerificationFlowKt.getDocumentUploadSteps(this.getVerificationFlow());
        VerificationStep verificationStep = (VerificationStep)CollectionsKt.first(this.getVerificationFlow().getVerificationSteps());
        VerificationState verificationState = new VerificationStarted();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void group2;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)group2;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Document document = (Document)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string2 = it.getId();
                collection2.add(string2);
            }
            List list2 = (List)destination$iv$iv2;
            collection.add(list2);
        }
        collection = (List)destination$iv$iv;
        String string3 = VerificationFlowKt.getBiometryType(this.getVerificationFlow());
        int n = this.getVerificationFlow().getVerificationSteps().size();
        List list = collection;
        VerificationStep verificationStep2 = verificationStep;
        VerificationState verificationState2 = verificationState;
        AnalyticsKt.track(new Verification(verificationState2, verificationStep2, list, n, string3));
        InputError inputError = this.getRestrictionError();
        String string4 = inputError != null ? inputError.getCode() : null;
        if (string4 != null) {
            switch (string4) {
                case "connectionData.restricted": {
                    InputError inputError2 = this.getRestrictionError();
                    Intrinsics.checkNotNull((Object)inputError2);
                    this.navigateTo(IpCountryRestrictedFragment.Companion.destination(inputError2.isCritical()));
                    return;
                }
                case "connectionData.vpnDetected": {
                    InputError inputError3 = this.getRestrictionError();
                    Intrinsics.checkNotNull((Object)inputError3);
                    this.navigateTo(VpnDetectedFragment.Companion.destination(inputError3.isCritical()));
                    return;
                }
            }
        }
        this.openVerificationStep(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void openVerificationStep(int verificationStepIdx) {
        void $this$apply;
        MatiDestination nextStepDestination;
        boolean bl;
        MatiDestination matiDestination;
        this.currentVerificationStepIdx = verificationStepIdx;
        VerificationStep verificationStep = this.getVerificationFlow().getVerificationSteps().get(verificationStepIdx);
        if (verificationStep instanceof ESignVerificationStep) {
            matiDestination = ESignHostFragment.Companion.destination();
        } else if (verificationStep instanceof DocumentVerificationStep) {
            if (((DocumentVerificationStep)verificationStep).getAcceptableDocuments().size() == 1) {
                Document doc2 = (Document)CollectionsKt.first(((DocumentVerificationStep)verificationStep).getAcceptableDocuments());
                boolean skippable2 = doc2 instanceof CustomDoc && ((CustomDoc)doc2).getSkippable();
                switch (this.supportedCountries.size()) {
                    case 1: {
                        doc2.setCountry(this.supportedCountries.get(0));
                        CountriesRepo countriesRepo = this.getCountriesRepo();
                        Country country = doc2.getCountry();
                        Intrinsics.checkNotNull((Object)country);
                        if (countriesRepo.shouldShowSelectRegion(country.getCode(), doc2)) {
                            matiDestination = SelectCountryFragment.Companion.destination(doc2, ((DocumentVerificationStep)verificationStep).getGroup(), skippable2);
                            break;
                        }
                        matiDestination = DocumentHintFragment.Companion.destination(new DocPage<Document>(doc2, 1), ((DocumentVerificationStep)verificationStep).getGroup(), skippable2);
                        break;
                    }
                    default: {
                        matiDestination = SelectCountryFragment.Companion.destination(doc2, ((DocumentVerificationStep)verificationStep).getGroup(), skippable2);
                        break;
                    }
                }
            } else {
                matiDestination = SelectDocumentFragment.Companion.destination((DocumentVerificationStep)verificationStep);
            }
        } else if (verificationStep instanceof BiometryUpload) {
            AnalyticsKt.track(new BiometryUploadEvent(new Started(), ((BiometryUpload)verificationStep).getBiometryType()));
            switch (MatiNavigation$WhenMappings.$EnumSwitchMapping$0[((BiometryUpload)verificationStep).getBiometryType().ordinal()]) {
                case 1: {
                    matiDestination = LivenessFragment.Companion.destination();
                    break;
                }
                case 2: {
                    matiDestination = VoiceLivenessFragment.Companion.destination();
                    break;
                }
                case 3: {
                    matiDestination = SelfieHintFragment.Companion.destination();
                    break;
                }
                default: {
                    matiDestination = ExitFragment.Companion.destination();
                    break;
                }
            }
        } else if (verificationStep instanceof SmsUpload) {
            matiDestination = PhoneInputFragment.Companion.destination(((SmsUpload)verificationStep).getOptional(), ((SmsUpload)verificationStep).getTimeoutMs());
        } else if (verificationStep instanceof EmailVerification) {
            VerificationStep verificationStep2 = verificationStep;
            bl = false;
            boolean bl2 = false;
            EmailVerification $this$run = (EmailVerification)verificationStep2;
            boolean bl3 = false;
            matiDestination = EmailSubmissionFragment.Companion.destination($this$run.getOptional(), $this$run.getAttemptLimit(), $this$run.getCoolDown());
        } else {
            matiDestination = verificationStep instanceof WebVerificationStep ? WebVerificationFragment.Companion.destination(((WebVerificationStep)verificationStep).getType()) : ExitFragment.Companion.destination();
        }
        MatiDestination matiDestination2 = nextStepDestination = matiDestination;
        boolean bl4 = false;
        bl = false;
        MatiDestination matiDestination3 = matiDestination2;
        MatiNavigation matiNavigation = this;
        boolean bl5 = false;
        $this$apply.getArgs().putBoolean("ARG_NEW_STEP_STARTED", true);
        Unit unit = Unit.INSTANCE;
        matiNavigation.navigateTo(matiDestination2);
    }

    /*
     * WARNING - void declaration
     */
    public final void openNextStep() {
        if (this.currentVerificationStepIdx == CollectionsKt.getLastIndex(this.getVerificationFlow().getVerificationSteps())) {
            void $this$apply;
            MatiDestination matiDestination = VerificationSuccessFragment.Companion.destination();
            boolean bl = false;
            boolean bl2 = false;
            MatiDestination matiDestination2 = matiDestination;
            MatiNavigation matiNavigation = this;
            boolean bl3 = false;
            $this$apply.getArgs().putBoolean("ARG_NEW_STEP_STARTED", true);
            Unit unit = Unit.INSTANCE;
            matiNavigation.navigateTo(matiDestination);
        } else {
            this.openVerificationStep(this.currentVerificationStepIdx + 1);
        }
    }

    public final void navigateTo(@NotNull MatiDestination destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.getNavController().navigate(destination.getActionId(), destination.getArgs());
    }

    public final void back() {
        this.getNavController().popBackStack();
    }

    /*
     * WARNING - void declaration
     */
    public final void cancelVerification() {
        VerificationFlow verificationFlow2 = this.getVerificationFlow();
        boolean bl = false;
        boolean bl2 = false;
        VerificationFlow $this$apply = verificationFlow2;
        boolean bl3 = false;
        Collection collection = $this$apply.getVerificationSteps();
        int n = 0;
        if (!collection.isEmpty()) {
            Collection<List> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n2 = this.currentVerificationStepIdx;
            n = 0;
            boolean bl4 = false;
            Iterable iterable = VerificationFlowKt.getDocumentUploadSteps($this$apply);
            VerificationStep verificationStep = $this$apply.getVerificationSteps().get(Math.max(n2, n));
            VerificationState verificationState = new VerificationCanceled();
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void group2;
                List list = (List)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl5 = false;
                Iterable $this$map$iv2 = (Iterable)group2;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    Document document = (Document)item$iv$iv2;
                    Collection collection3 = destination$iv$iv2;
                    boolean bl6 = false;
                    String string2 = it.getId();
                    collection3.add(string2);
                }
                List list2 = (List)destination$iv$iv2;
                collection2.add(list2);
            }
            collection2 = (List)destination$iv$iv;
            String string3 = VerificationFlowKt.getBiometryType($this$apply);
            int n3 = $this$apply.getVerificationSteps().size();
            List list = collection2;
            VerificationStep verificationStep2 = verificationStep;
            VerificationState verificationState2 = verificationState;
            AnalyticsKt.track(new Verification(verificationState2, verificationStep2, list, n3, string3));
        }
        this.finishWithResult(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void finishVerification() {
        Collection<List> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = VerificationFlowKt.getDocumentUploadSteps(this.getVerificationFlow());
        VerificationStep verificationStep = (VerificationStep)CollectionsKt.last(this.getVerificationFlow().getVerificationSteps());
        VerificationState verificationState = new VerificationPassed();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void group2;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)group2;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Document document = (Document)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string2 = it.getId();
                collection2.add(string2);
            }
            List list2 = (List)destination$iv$iv2;
            collection.add(list2);
        }
        collection = (List)destination$iv$iv;
        String string3 = VerificationFlowKt.getBiometryType(this.getVerificationFlow());
        int n = this.getVerificationFlow().getVerificationSteps().size();
        List list = collection;
        VerificationStep verificationStep2 = verificationStep;
        VerificationState verificationState2 = verificationState;
        AnalyticsKt.track(new Verification(verificationState2, verificationStep2, list, n, string3));
        this.finishWithResult(-1);
    }

    /*
     * WARNING - void declaration
     */
    private final void finishWithResult(int result2) {
        void $this$apply;
        Intent intent = new Intent();
        boolean bl = false;
        boolean bl2 = false;
        Intent intent2 = intent;
        int n = result2;
        VerificationActivity verificationActivity = this.activity;
        boolean bl3 = false;
        $this$apply.putExtra("ARG_IDENTITY_ID", this.verificationVm.getPrefetchedData().getIdentityId());
        $this$apply.putExtra("ARG_VERIFICATION_ID", this.verificationVm.getPrefetchedData().getVerificationId());
        Unit unit = Unit.INSTANCE;
        verificationActivity.setResult(n, intent);
        this.activity.finish();
    }

    @NotNull
    public Bundle saveState() {
        return BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)ARG_VERIFICATION_STEP_IDX, (Object)this.currentVerificationStepIdx)});
    }

    @NotNull
    public final VerificationActivity getActivity() {
        return this.activity;
    }

    @NotNull
    public final VerificationVm getVerificationVm() {
        return this.verificationVm;
    }

    public MatiNavigation(@NotNull VerificationActivity activity, @NotNull VerificationVm verificationVm, @NotNull SavedStateRegistryOwner registryOwner) {
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationVm), (String)"verificationVm");
        Intrinsics.checkNotNullParameter((Object)registryOwner, (String)"registryOwner");
        this.activity = activity;
        this.verificationVm = verificationVm;
        this.registryOwner = registryOwner;
        MatiNavigation $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.countriesRepo$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<CountriesRepo>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CountriesRepo invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(CountriesRepo.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(CountriesRepo.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.currentVerificationStepIdx = -1;
        this.registryOwner.getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(){

            public final void onStateChanged(@NotNull LifecycleOwner $noName_0, @NotNull Lifecycle.Event event) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event != Lifecycle.Event.ON_CREATE) break block1;
                    SavedStateRegistry savedStateRegistry = registryOwner.getSavedStateRegistry();
                    Intrinsics.checkNotNullExpressionValue((Object)savedStateRegistry, (String)"registryOwner.savedStateRegistry");
                    SavedStateRegistry registry = savedStateRegistry;
                    registry.registerSavedStateProvider(MatiNavigation.PROVIDER, (SavedStateRegistry.SavedStateProvider)this);
                    Bundle bundle = registry.consumeRestoredStateForKey(MatiNavigation.PROVIDER);
                    if (bundle != null) {
                        Bundle bundle2 = bundle;
                        boolean bl = false;
                        boolean bl2 = false;
                        Bundle $this$run = bundle2;
                        boolean bl3 = false;
                        currentVerificationStepIdx = $this$run.getInt(MatiNavigation.ARG_VERIFICATION_STEP_IDX);
                    }
                }
            }
        });
        this.navController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NavController>(this){
            final /* synthetic */ MatiNavigation this$0;

            @NotNull
            public final NavController invoke() {
                return Navigation.findNavController((Activity)((Activity)this.this$0.getActivity()), (int)R.id.nav_host_fragment);
            }
            {
                this.this$0 = matiNavigation;
                super(0);
            }
        }));
        this.supportedCountries = this.getCountriesRepo().filterSupported(this.getVerificationFlow().getSupportedCountries());
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }

    public static final /* synthetic */ int access$getCurrentVerificationStepIdx$p(MatiNavigation $this) {
        return $this.currentVerificationStepIdx;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/getmati/mati_sdk/mati_navigation/MatiNavigation$Companion;", "", "()V", "ARG_VERIFICATION_STEP_IDX", "", "PROVIDER", "mati-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

