/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.DateUtils;
import com.getmati.mati_sdk.sentry.io.sentry.IUnknownPropertiesConsumer;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.util.CollectionUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Breadcrumb
implements IUnknownPropertiesConsumer {
    @NotNull
    private final Date timestamp;
    @Nullable
    private String message;
    @Nullable
    private String type;
    @NotNull
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    @Nullable
    private String category;
    @Nullable
    private SentryLevel level;
    @Nullable
    private Map<String, Object> unknown;

    public Breadcrumb(@NotNull Date timestamp) {
        this.timestamp = timestamp;
    }

    Breadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.timestamp = breadcrumb.timestamp;
        this.message = breadcrumb.message;
        this.type = breadcrumb.type;
        this.category = breadcrumb.category;
        Map<String, Object> dataClone = CollectionUtils.newConcurrentHashMap(breadcrumb.data);
        if (dataClone != null) {
            this.data = dataClone;
        }
        this.unknown = CollectionUtils.newConcurrentHashMap(breadcrumb.unknown);
        this.level = breadcrumb.level;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url, @NotNull String method) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("http");
        breadcrumb.setCategory("http");
        breadcrumb.setData("url", url);
        breadcrumb.setData("method", method.toUpperCase(Locale.ROOT));
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url, @NotNull String method, @Nullable Integer code) {
        Breadcrumb breadcrumb = Breadcrumb.http(url, method);
        if (code != null) {
            breadcrumb.setData("status_code", code);
        }
        return breadcrumb;
    }

    public Breadcrumb() {
        this(DateUtils.getCurrentDateTime());
    }

    public Breadcrumb(@Nullable String message) {
        this();
        this.message = message;
    }

    @NotNull
    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Object getData(@NotNull String key) {
        return this.data.get(key);
    }

    public void setData(@NotNull String key, @NotNull Object value) {
        this.data.put(key, value);
    }

    public void removeData(@NotNull String key) {
        this.data.remove(key);
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Override
    public void acceptUnknownProperties(@NotNull Map<String, Object> unknown) {
        this.unknown = new ConcurrentHashMap<String, Object>(unknown);
    }

    @Nullable
    Map<String, Object> getUnknown() {
        return this.unknown;
    }
}

