/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public final class DateUtils {
    private static final String UTC = "UTC";
    private static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String ISO_FORMAT_WITH_MILLIS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @NotNull
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> SDF_ISO_FORMAT_WITH_MILLIS_UTC = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtils.ISO_FORMAT_WITH_MILLIS, Locale.ROOT);
            simpleDateFormat.setTimeZone(UTC_TIMEZONE);
            return simpleDateFormat;
        }
    };
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> SDF_ISO_FORMAT_UTC = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtils.ISO_FORMAT, Locale.ROOT);
            simpleDateFormat.setTimeZone(UTC_TIMEZONE);
            return simpleDateFormat;
        }
    };

    private DateUtils() {
    }

    @NotNull
    public static Date getCurrentDateTime() {
        Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
        return calendar.getTime();
    }

    @NotNull
    public static Date getDateTime(@NotNull String timestamp) throws IllegalArgumentException {
        try {
            return SDF_ISO_FORMAT_WITH_MILLIS_UTC.get().parse(timestamp);
        }
        catch (ParseException e) {
            try {
                return SDF_ISO_FORMAT_UTC.get().parse(timestamp);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("timestamp is not ISO format " + timestamp);
            }
        }
    }

    @NotNull
    public static Date getDateTimeWithMillisPrecision(@NotNull String timestamp) throws IllegalArgumentException {
        try {
            String[] times = timestamp.split("\\.", -1);
            long seconds = Long.parseLong(times[0]);
            long millis = times.length > 1 ? Long.parseLong(times[1]) : 0L;
            return DateUtils.getDateTime(seconds * 1000L + millis);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("timestamp is not millis format " + timestamp);
        }
    }

    @NotNull
    public static String getTimestamp(@NotNull Date date) {
        DateFormat df = SDF_ISO_FORMAT_WITH_MILLIS_UTC.get();
        return df.format(date);
    }

    @NotNull
    public static Date getDateTime(long millis) {
        Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
        calendar.setTimeInMillis(millis);
        return calendar.getTime();
    }
}

