/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.Scope;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelope;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.Session;
import com.getmati.mati_sdk.sentry.io.sentry.UserFeedback;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Message;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryTransaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISentryClient {
    public boolean isEnabled();

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable Scope var2, @Nullable Object var3);

    public void close();

    public void flush(long var1);

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event) {
        return this.captureEvent(event, null, null);
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Scope scope) {
        return this.captureEvent(event, scope, null);
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Object hint) {
        return this.captureEvent(event, null, hint);
    }

    @NotNull
    default public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level, @Nullable Scope scope) {
        SentryEvent event = new SentryEvent();
        Message sentryMessage = new Message();
        sentryMessage.setFormatted(message);
        event.setMessage(sentryMessage);
        event.setLevel(level);
        return this.captureEvent(event, scope);
    }

    @NotNull
    default public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return this.captureMessage(message, level, null);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable) {
        return this.captureException(throwable, null, null);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable Scope scope, @Nullable Object hint) {
        SentryEvent event = new SentryEvent(throwable);
        return this.captureEvent(event, scope, hint);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable Object hint) {
        return this.captureException(throwable, null, hint);
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @Nullable Scope scope) {
        return this.captureException(throwable, scope, null);
    }

    public void captureUserFeedback(@NotNull UserFeedback var1);

    public void captureSession(@NotNull Session var1, @Nullable Object var2);

    default public void captureSession(@NotNull Session session) {
        this.captureSession(session, null);
    }

    @Nullable
    public SentryId captureEnvelope(@NotNull SentryEnvelope var1, @Nullable Object var2);

    @Nullable
    default public SentryId captureEnvelope(@NotNull SentryEnvelope envelope) {
        return this.captureEnvelope(envelope, null);
    }

    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction var1, @Nullable Scope var2, @Nullable Object var3);

    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction) {
        return this.captureTransaction(transaction, null, null);
    }
}

