/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.EventProcessor;
import com.getmati.mati_sdk.sentry.io.sentry.HostnameCache;
import com.getmati.mati_sdk.sentry.io.sentry.SentryBaseEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryExceptionFactory;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.SentryStackTraceFactory;
import com.getmati.mati_sdk.sentry.io.sentry.SentryThreadFactory;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Cached;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryException;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryTransaction;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.User;
import com.getmati.mati_sdk.sentry.io.sentry.util.ApplyScopeUtils;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MainEventProcessor
implements EventProcessor {
    private static final String DEFAULT_ENVIRONMENT = "production";
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryThreadFactory sentryThreadFactory;
    @NotNull
    private final SentryExceptionFactory sentryExceptionFactory;
    @Nullable
    private final HostnameCache hostnameCache;

    MainEventProcessor(@NotNull SentryOptions options) {
        this(options, options.isAttachServerName() ? new HostnameCache() : null);
    }

    MainEventProcessor(@NotNull SentryOptions options, @Nullable HostnameCache hostnameCache) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        this.hostnameCache = hostnameCache;
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(this.options.getInAppExcludes(), this.options.getInAppIncludes());
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory(sentryStackTraceFactory, this.options);
    }

    MainEventProcessor(@NotNull SentryOptions options, @NotNull SentryThreadFactory sentryThreadFactory, @NotNull SentryExceptionFactory sentryExceptionFactory, @NotNull HostnameCache hostnameCache) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        this.sentryThreadFactory = Objects.requireNonNull(sentryThreadFactory, "The SentryThreadFactory is required.");
        this.sentryExceptionFactory = Objects.requireNonNull(sentryExceptionFactory, "The SentryExceptionFactory is required.");
        this.hostnameCache = Objects.requireNonNull(hostnameCache, "The HostnameCache is required");
    }

    @Override
    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Object hint) {
        this.setCommons(event);
        this.setExceptions(event);
        if (this.shouldApplyScopeData(event, hint)) {
            this.processNonCachedEvent(event);
            this.setThreads(event, hint);
        }
        return event;
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @Nullable Object hint) {
        if (ApplyScopeUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", event.getEventId());
        return false;
    }

    private void processNonCachedEvent(@NotNull SentryBaseEvent event) {
        this.setRelease(event);
        this.setEnvironment(event);
        this.setServerName(event);
        this.setDist(event);
        this.setSdk(event);
        this.setTags(event);
        this.mergeUser(event);
    }

    @Override
    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @Nullable Object hint) {
        this.setCommons(transaction);
        if (this.shouldApplyScopeData(transaction, hint)) {
            this.processNonCachedEvent(transaction);
        }
        return transaction;
    }

    private void setCommons(@NotNull SentryBaseEvent event) {
        this.setPlatform(event);
    }

    private void setPlatform(@NotNull SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
    }

    private void setRelease(@NotNull SentryBaseEvent event) {
        if (event.getRelease() == null) {
            event.setRelease(this.options.getRelease());
        }
    }

    private void setEnvironment(@NotNull SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            event.setEnvironment(this.options.getEnvironment() != null ? this.options.getEnvironment() : DEFAULT_ENVIRONMENT);
        }
    }

    private void setServerName(@NotNull SentryBaseEvent event) {
        if (event.getServerName() == null) {
            event.setServerName(this.options.getServerName());
        }
        if (this.options.isAttachServerName() && this.hostnameCache != null && event.getServerName() == null) {
            event.setServerName(this.hostnameCache.getHostname());
        }
    }

    private void setDist(@NotNull SentryBaseEvent event) {
        if (event.getDist() == null) {
            event.setDist(this.options.getDist());
        }
    }

    private void setSdk(@NotNull SentryBaseEvent event) {
        if (event.getSdk() == null) {
            event.setSdk(this.options.getSdkVersion());
        }
    }

    private void setTags(@NotNull SentryBaseEvent event) {
        if (event.getTags() == null) {
            event.setTags(new HashMap<String, String>(this.options.getTags()));
        } else {
            for (Map.Entry<String, String> item : this.options.getTags().entrySet()) {
                if (event.getTags().containsKey(item.getKey())) continue;
                event.setTag(item.getKey(), item.getValue());
            }
        }
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        if (this.options.isSendDefaultPii()) {
            if (event.getUser() == null) {
                User user = new User();
                user.setIpAddress("{{auto}}");
                event.setUser(user);
            } else if (event.getUser().getIpAddress() == null) {
                event.getUser().setIpAddress("{{auto}}");
            }
        }
    }

    private void setExceptions(@NotNull SentryEvent event) {
        Throwable throwable = event.getThrowableMechanism();
        if (throwable != null) {
            event.setExceptions(this.sentryExceptionFactory.getSentryExceptions(throwable));
        }
    }

    private void setThreads(@NotNull SentryEvent event, @Nullable Object hint) {
        if (event.getThreads() == null) {
            ArrayList<Long> mechanismThreadIds = null;
            List<SentryException> eventExceptions = event.getExceptions();
            if (eventExceptions != null && !eventExceptions.isEmpty()) {
                for (SentryException item : eventExceptions) {
                    if (item.getMechanism() == null || item.getThreadId() == null) continue;
                    if (mechanismThreadIds == null) {
                        mechanismThreadIds = new ArrayList<Long>();
                    }
                    mechanismThreadIds.add(item.getThreadId());
                }
            }
            if (this.options.isAttachThreads()) {
                event.setThreads(this.sentryThreadFactory.getCurrentThreads(mechanismThreadIds));
            } else if (this.options.isAttachStacktrace() && (eventExceptions == null || eventExceptions.isEmpty()) && !this.isCachedHint(hint)) {
                event.setThreads(this.sentryThreadFactory.getCurrentThread());
            }
        }
    }

    private boolean isCachedHint(@Nullable Object hint) {
        return hint instanceof Cached;
    }
}

