/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.DirectoryProcessor;
import com.getmati.mati_sdk.sentry.io.sentry.IEnvelopeReader;
import com.getmati.mati_sdk.sentry.io.sentry.IEnvelopeSender;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.ISerializer;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelope;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelopeItem;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryItemType;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Flushable;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Resettable;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Retryable;
import com.getmati.mati_sdk.sentry.io.sentry.hints.SubmissionResult;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryTransaction;
import com.getmati.mati_sdk.sentry.io.sentry.util.CollectionUtils;
import com.getmati.mati_sdk.sentry.io.sentry.util.LogUtils;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OutboxSender
extends DirectoryProcessor
implements IEnvelopeSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final IHub hub;
    @NotNull
    private final IEnvelopeReader envelopeReader;
    @NotNull
    private final ISerializer serializer;
    @NotNull
    private final ILogger logger;

    public OutboxSender(@NotNull IHub hub, @NotNull IEnvelopeReader envelopeReader, @NotNull ISerializer serializer2, @NotNull ILogger logger, long flushTimeoutMillis) {
        super(logger, flushTimeoutMillis);
        this.hub = Objects.requireNonNull(hub, "Hub is required.");
        this.envelopeReader = Objects.requireNonNull(envelopeReader, "Envelope reader is required.");
        this.serializer = Objects.requireNonNull(serializer2, "Serializer is required.");
        this.logger = Objects.requireNonNull(logger, "Logger is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFile(@NotNull File file, @Nullable Object hint) {
        block29: {
            Objects.requireNonNull(file, "File is required.");
            if (!this.isRelevantFileName(file.getName())) {
                this.logger.log(SentryLevel.DEBUG, "File '%s' should be ignored.", file.getAbsolutePath());
                return;
            }
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                SentryEnvelope envelope = this.envelopeReader.read(stream);
                if (envelope == null) {
                    this.logger.log(SentryLevel.ERROR, "Stream from path %s resulted in a null envelope.", file.getAbsolutePath());
                } else {
                    this.processEnvelope(envelope, hint);
                    this.logger.log(SentryLevel.DEBUG, "File '%s' is done.", file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                try {
                    this.logger.log(SentryLevel.ERROR, "Error processing envelope.", e);
                }
                catch (Throwable throwable) {
                    if (hint instanceof Retryable) {
                        if (!((Retryable)hint).isRetry()) {
                            try {
                                if (!file.delete()) {
                                    this.logger.log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
                                }
                            }
                            catch (RuntimeException e2) {
                                this.logger.log(SentryLevel.ERROR, e2, "Failed to delete: %s", file.getAbsolutePath());
                            }
                        }
                    } else {
                        LogUtils.logIfNotRetryable(this.logger, hint);
                    }
                    throw throwable;
                }
                if (hint instanceof Retryable) {
                    if (((Retryable)hint).isRetry()) break block29;
                    try {
                        if (!file.delete()) {
                            this.logger.log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
                        }
                    }
                    catch (RuntimeException e3) {
                        this.logger.log(SentryLevel.ERROR, e3, "Failed to delete: %s", file.getAbsolutePath());
                    }
                }
                LogUtils.logIfNotRetryable(this.logger, hint);
            }
            if (hint instanceof Retryable) {
                if (!((Retryable)hint).isRetry()) {
                    try {
                        if (!file.delete()) {
                            this.logger.log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
                        }
                    }
                    catch (RuntimeException e) {
                        this.logger.log(SentryLevel.ERROR, e, "Failed to delete: %s", file.getAbsolutePath());
                    }
                }
            } else {
                LogUtils.logIfNotRetryable(this.logger, hint);
            }
        }
    }

    @Override
    protected boolean isRelevantFileName(@Nullable String fileName) {
        return fileName != null && !fileName.startsWith("session");
    }

    @Override
    public void processEnvelopeFile(@NotNull String path2, @Nullable Object hint) {
        Objects.requireNonNull(path2, "Path is required.");
        this.processFile(new File(path2), hint);
    }

    private void processEnvelope(@NotNull SentryEnvelope envelope, @Nullable Object hint) throws IOException {
        this.logger.log(SentryLevel.DEBUG, "Processing Envelope with %d item(s)", CollectionUtils.size(envelope.getItems()));
        int currentItem = 0;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            block31: {
                ++currentItem;
                if (item.getHeader() == null) {
                    this.logger.log(SentryLevel.ERROR, "Item %d has no header", currentItem);
                    continue;
                }
                if (SentryItemType.Event.equals((Object)item.getHeader().getType())) {
                    try {
                        BufferedReader eventReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));
                        try {
                            SentryEvent event = this.serializer.deserialize(eventReader, SentryEvent.class);
                            if (event == null) {
                                this.logEnvelopeItemNull(item, currentItem);
                            } else {
                                if (envelope.getHeader().getEventId() != null && !envelope.getHeader().getEventId().equals(event.getEventId())) {
                                    this.logUnexpectedEventId(envelope, event.getEventId(), currentItem);
                                    continue;
                                }
                                this.hub.captureEvent(event, hint);
                                this.logItemCaptured(currentItem);
                                if (!this.waitFlush(hint)) {
                                    this.logTimeout(event.getEventId());
                                    break;
                                }
                            }
                            break block31;
                        }
                        finally {
                            ((Reader)eventReader).close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.logger.log(SentryLevel.ERROR, "Item failed to process.", e);
                        break block31;
                    }
                }
                if (SentryItemType.Transaction.equals((Object)item.getHeader().getType())) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));
                        try {
                            SentryTransaction transaction = this.serializer.deserialize(reader, SentryTransaction.class);
                            if (transaction == null) {
                                this.logEnvelopeItemNull(item, currentItem);
                            } else {
                                if (envelope.getHeader().getEventId() != null && !envelope.getHeader().getEventId().equals(transaction.getEventId())) {
                                    this.logUnexpectedEventId(envelope, transaction.getEventId(), currentItem);
                                    continue;
                                }
                                if (transaction.getContexts().getTrace() != null) {
                                    transaction.getContexts().getTrace().setSampled(true);
                                }
                                this.hub.captureTransaction(transaction, hint);
                                this.logItemCaptured(currentItem);
                                if (!this.waitFlush(hint)) {
                                    this.logTimeout(transaction.getEventId());
                                    break;
                                }
                            }
                            break block31;
                        }
                        finally {
                            ((Reader)reader).close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.logger.log(SentryLevel.ERROR, "Item failed to process.", e);
                        break block31;
                    }
                }
                SentryEnvelope newEnvelope = new SentryEnvelope(envelope.getHeader().getEventId(), envelope.getHeader().getSdkVersion(), item);
                this.hub.captureEnvelope(newEnvelope, hint);
                this.logger.log(SentryLevel.DEBUG, "%s item %d is being captured.", item.getHeader().getType().getItemType(), currentItem);
                if (!this.waitFlush(hint)) {
                    this.logger.log(SentryLevel.WARNING, "Timed out waiting for item type submission: %s", item.getHeader().getType().getItemType());
                    break;
                }
            }
            if (hint instanceof SubmissionResult && !((SubmissionResult)hint).isSuccess()) {
                this.logger.log(SentryLevel.WARNING, "Envelope had a failed capture at item %d. No more items will be sent.", currentItem);
                break;
            }
            if (!(hint instanceof Resettable)) continue;
            ((Resettable)hint).reset();
        }
    }

    private void logEnvelopeItemNull(@NotNull SentryEnvelopeItem item, int itemIndex) {
        this.logger.log(SentryLevel.ERROR, "Item %d of type %s returned null by the parser.", new Object[]{itemIndex, item.getHeader().getType()});
    }

    private void logUnexpectedEventId(@NotNull SentryEnvelope envelope, @Nullable SentryId eventId, int itemIndex) {
        this.logger.log(SentryLevel.ERROR, "Item %d of has a different event id (%s) to the envelope header (%s)", itemIndex, envelope.getHeader().getEventId(), eventId);
    }

    private void logItemCaptured(int itemIndex) {
        this.logger.log(SentryLevel.DEBUG, "Item %d is being captured.", itemIndex);
    }

    private void logTimeout(@Nullable SentryId eventId) {
        this.logger.log(SentryLevel.WARNING, "Timed out waiting for event id submission: %s", eventId);
    }

    private boolean waitFlush(@Nullable Object hint) {
        if (hint instanceof Flushable) {
            return ((Flushable)hint).waitFlush();
        }
        LogUtils.logIfNotFlushable(this.logger, hint);
        return true;
    }
}

