/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.Dsn;
import com.getmati.mati_sdk.sentry.io.sentry.RequestDetails;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.net.URI;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

final class RequestDetailsResolver {
    private static final String USER_AGENT = "User-Agent";
    private static final String SENTRY_AUTH = "X-Sentry-Auth";
    @NotNull
    private final SentryOptions options;

    public RequestDetailsResolver(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "options is required");
    }

    @NotNull
    RequestDetails resolve() {
        Dsn dsn = new Dsn(this.options.getDsn());
        URI sentryUri = dsn.getSentryUri();
        String envelopeUrl = sentryUri.resolve(sentryUri.getPath() + "/envelope/").toString();
        String publicKey = dsn.getPublicKey();
        String secretKey = dsn.getSecretKey();
        String authHeader = "Sentry sentry_version=7,sentry_client=" + this.options.getSentryClientName() + ",sentry_key=" + publicKey + (secretKey != null && secretKey.length() > 0 ? ",sentry_secret=" + secretKey : "");
        String userAgent = this.options.getSentryClientName();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(USER_AGENT, userAgent);
        headers.put(SENTRY_AUTH, authHeader);
        return new RequestDetails(envelopeUrl, headers);
    }
}

