/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.Breadcrumb;
import com.getmati.mati_sdk.sentry.io.sentry.CustomSamplingContext;
import com.getmati.mati_sdk.sentry.io.sentry.Dsn;
import com.getmati.mati_sdk.sentry.io.sentry.Hub;
import com.getmati.mati_sdk.sentry.io.sentry.HubAdapter;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.ISentryClient;
import com.getmati.mati_sdk.sentry.io.sentry.ISpan;
import com.getmati.mati_sdk.sentry.io.sentry.ITransaction;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.NoOpHub;
import com.getmati.mati_sdk.sentry.io.sentry.NoOpLogger;
import com.getmati.mati_sdk.sentry.io.sentry.OptionsContainer;
import com.getmati.mati_sdk.sentry.io.sentry.ScopeCallback;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.SentryTraceHeader;
import com.getmati.mati_sdk.sentry.io.sentry.SystemOutLogger;
import com.getmati.mati_sdk.sentry.io.sentry.TransactionContext;
import com.getmati.mati_sdk.sentry.io.sentry.UserFeedback;
import com.getmati.mati_sdk.sentry.io.sentry.cache.EnvelopeCache;
import com.getmati.mati_sdk.sentry.io.sentry.config.PropertiesProviderFactory;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.User;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Sentry {
    @NotNull
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    @NotNull
    private static volatile IHub mainHub = NoOpHub.getInstance();
    private static final boolean GLOBAL_HUB_DEFAULT_MODE = false;
    private static volatile boolean globalHubMode = false;

    private Sentry() {
    }

    @NotNull
    public static IHub getCurrentHub() {
        if (globalHubMode) {
            return mainHub;
        }
        IHub hub = currentHub.get();
        if (hub == null) {
            hub = mainHub.clone();
            currentHub.set(hub);
        }
        return hub;
    }

    public static void setCurrentHub(@NotNull IHub hub) {
        currentHub.set(hub);
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init() {
        Sentry.init((SentryOptions options) -> options.setEnableExternalConfiguration(true), false);
    }

    public static void init(@NotNull String dsn) {
        Sentry.init((SentryOptions options) -> options.setDsn(dsn));
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Sentry.init(clazz, optionsConfiguration, false);
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration, boolean globalHubMode) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        SentryOptions options = (SentryOptions)clazz.createInstance();
        optionsConfiguration.configure(options);
        Sentry.init(options, globalHubMode);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration) {
        Sentry.init(optionsConfiguration, false);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration, boolean globalHubMode) {
        SentryOptions options = new SentryOptions();
        optionsConfiguration.configure(options);
        Sentry.init(options, globalHubMode);
    }

    public static void init(@NotNull SentryOptions options) {
        Sentry.init(options, false);
    }

    private static synchronized void init(@NotNull SentryOptions options, boolean globalHubMode) {
        if (Sentry.isEnabled()) {
            options.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
        }
        if (!Sentry.initConfigurations(options)) {
            return;
        }
        options.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubMode));
        Sentry.globalHubMode = globalHubMode;
        IHub hub = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        hub.close();
        for (Integration integration : options.getIntegrations()) {
            integration.register(HubAdapter.getInstance(), options);
        }
    }

    private static boolean initConfigurations(@NotNull SentryOptions options) {
        String dsn;
        if (options.isEnableExternalConfiguration()) {
            options.merge(SentryOptions.from(PropertiesProviderFactory.create(), options.getLogger()));
        }
        if ((dsn = options.getDsn()) == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string to disable SDK.");
        }
        if (dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        Dsn parsedDsn = new Dsn(dsn);
        ILogger logger = options.getLogger();
        if (options.isDebug() && logger instanceof NoOpLogger) {
            options.setLogger(new SystemOutLogger());
            logger = options.getLogger();
        }
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        if (options.getOutboxPath() != null) {
            File outboxDir = new File(options.getOutboxPath());
            outboxDir.mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        if (options.getCacheDirPath() != null && !options.getCacheDirPath().isEmpty()) {
            File cacheDir = new File(options.getCacheDirPath());
            cacheDir.mkdirs();
            options.setEnvelopeDiskCache(EnvelopeCache.create(options));
        }
        return true;
    }

    public static synchronized void close() {
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        hub.close();
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event) {
        return Sentry.getCurrentHub().captureEvent(event);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @Nullable Object hint) {
        return Sentry.getCurrentHub().captureEvent(event, hint);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message) {
        return Sentry.getCurrentHub().captureMessage(message);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return Sentry.getCurrentHub().captureMessage(message, level);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable) {
        return Sentry.getCurrentHub().captureException(throwable);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Object hint) {
        return Sentry.getCurrentHub().captureException(throwable, hint);
    }

    public static void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        Sentry.getCurrentHub().captureUserFeedback(userFeedback);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb, hint);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb);
    }

    public static void addBreadcrumb(@NotNull String message) {
        Sentry.getCurrentHub().addBreadcrumb(message);
    }

    public static void addBreadcrumb(@NotNull String message, @NotNull String category) {
        Sentry.getCurrentHub().addBreadcrumb(message, category);
    }

    public static void setLevel(@Nullable SentryLevel level) {
        Sentry.getCurrentHub().setLevel(level);
    }

    public static void setTransaction(@Nullable String transaction) {
        Sentry.getCurrentHub().setTransaction(transaction);
    }

    public static void setUser(@Nullable User user) {
        Sentry.getCurrentHub().setUser(user);
    }

    public static void setFingerprint(@NotNull List<String> fingerprint) {
        Sentry.getCurrentHub().setFingerprint(fingerprint);
    }

    public static void clearBreadcrumbs() {
        Sentry.getCurrentHub().clearBreadcrumbs();
    }

    public static void setTag(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setTag(key, value);
    }

    public static void removeTag(@NotNull String key) {
        Sentry.getCurrentHub().removeTag(key);
    }

    public static void setExtra(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setExtra(key, value);
    }

    public static void removeExtra(@NotNull String key) {
        Sentry.getCurrentHub().removeExtra(key);
    }

    @NotNull
    public static SentryId getLastEventId() {
        return Sentry.getCurrentHub().getLastEventId();
    }

    public static void pushScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().pushScope();
        }
    }

    public static void popScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().popScope();
        }
    }

    public static void withScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().withScope(callback);
    }

    public static void configureScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().configureScope(callback);
    }

    public static void bindClient(@NotNull ISentryClient client2) {
        Sentry.getCurrentHub().bindClient(client2);
    }

    public static void flush(long timeoutMillis) {
        Sentry.getCurrentHub().flush(timeoutMillis);
    }

    public static void startSession() {
        Sentry.getCurrentHub().startSession();
    }

    public static void endSession() {
        Sentry.getCurrentHub().endSession();
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation) {
        return Sentry.getCurrentHub().startTransaction(name, operation);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(name, operation, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable String description) {
        return Sentry.startTransaction(name, operation, description, false);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable String description, boolean bindToScope) {
        ITransaction transaction = Sentry.getCurrentHub().startTransaction(name, operation, bindToScope);
        transaction.setDescription(description);
        return transaction;
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @NotNull CustomSamplingContext customSamplingContext) {
        return Sentry.getCurrentHub().startTransaction(name, operation, customSamplingContext);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @NotNull CustomSamplingContext customSamplingContext, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(name, operation, customSamplingContext, bindToScope);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts, @NotNull CustomSamplingContext customSamplingContext) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts, customSamplingContext);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts, @Nullable CustomSamplingContext customSamplingContext, boolean bindToScope) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts, customSamplingContext, bindToScope);
    }

    @Nullable
    public static SentryTraceHeader traceHeaders() {
        return Sentry.getCurrentHub().traceHeaders();
    }

    @Nullable
    public static ISpan getSpan() {
        return Sentry.getCurrentHub().getSpan();
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(@NotNull T var1);
    }
}

