/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.ISerializer;
import com.getmati.mati_sdk.sentry.io.sentry.SentryBaseEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelopeHeader;
import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelopeItem;
import com.getmati.mati_sdk.sentry.io.sentry.Session;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SdkVersion;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryEnvelope {
    @NotNull
    private final SentryEnvelopeHeader header;
    @NotNull
    private final Iterable<SentryEnvelopeItem> items;

    @NotNull
    public Iterable<SentryEnvelopeItem> getItems() {
        return this.items;
    }

    @NotNull
    public SentryEnvelopeHeader getHeader() {
        return this.header;
    }

    public SentryEnvelope(@NotNull SentryEnvelopeHeader header, @NotNull Iterable<SentryEnvelopeItem> items) {
        this.header = Objects.requireNonNull(header, "SentryEnvelopeHeader is required.");
        this.items = Objects.requireNonNull(items, "SentryEnvelope items are required.");
    }

    public SentryEnvelope(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @NotNull Iterable<SentryEnvelopeItem> items) {
        this.header = new SentryEnvelopeHeader(eventId, sdkVersion);
        this.items = Objects.requireNonNull(items, "SentryEnvelope items are required.");
    }

    public SentryEnvelope(@Nullable SentryId eventId, @Nullable SdkVersion sdkVersion, @NotNull SentryEnvelopeItem item) {
        Objects.requireNonNull(item, "SentryEnvelopeItem is required.");
        this.header = new SentryEnvelopeHeader(eventId, sdkVersion);
        ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>(1);
        items.add(item);
        this.items = items;
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer2, @NotNull Session session, @Nullable SdkVersion sdkVersion) throws IOException {
        Objects.requireNonNull(serializer2, "Serializer is required.");
        Objects.requireNonNull(session, "session is required.");
        return new SentryEnvelope(null, sdkVersion, SentryEnvelopeItem.fromSession(serializer2, session));
    }

    @NotNull
    public static SentryEnvelope from(@NotNull ISerializer serializer2, @NotNull SentryBaseEvent event, @Nullable SdkVersion sdkVersion) throws IOException {
        Objects.requireNonNull(serializer2, "Serializer is required.");
        Objects.requireNonNull(event, "item is required.");
        return new SentryEnvelope(event.getEventId(), sdkVersion, SentryEnvelopeItem.fromEvent(serializer2, event));
    }
}

