/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.DateUtils;
import com.getmati.mati_sdk.sentry.io.sentry.IUnknownPropertiesConsumer;
import com.getmati.mati_sdk.sentry.io.sentry.SentryBaseEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryValues;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.DebugMeta;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Message;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryException;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryThread;
import com.getmati.mati_sdk.sentry.io.sentry.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryEvent
extends SentryBaseEvent
implements IUnknownPropertiesConsumer {
    @NotNull
    private final Date timestamp;
    @Nullable
    private Message message;
    @Nullable
    private String logger;
    @Nullable
    private SentryValues<SentryThread> threads;
    @Nullable
    private SentryValues<SentryException> exception;
    @Nullable
    private SentryLevel level;
    @Nullable
    private String transaction;
    @Nullable
    private List<String> fingerprint;
    @Nullable
    private Map<String, Object> unknown;
    @Nullable
    private Map<String, String> modules;
    @Nullable
    private DebugMeta debugMeta;

    SentryEvent(@NotNull SentryId eventId, @NotNull Date timestamp) {
        super(eventId);
        this.timestamp = timestamp;
    }

    public SentryEvent(@Nullable Throwable throwable) {
        this();
        this.throwable = throwable;
    }

    public SentryEvent() {
        this(new SentryId(), DateUtils.getCurrentDateTime());
    }

    public SentryEvent(@NotNull Date timestamp) {
        this(new SentryId(), timestamp);
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable Message message) {
        this.message = message;
    }

    @Nullable
    public String getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable String logger) {
        this.logger = logger;
    }

    @Nullable
    public List<SentryThread> getThreads() {
        if (this.threads != null) {
            return this.threads.getValues();
        }
        return null;
    }

    public void setThreads(@Nullable List<SentryThread> threads) {
        this.threads = new SentryValues<SentryThread>(threads);
    }

    @Nullable
    public List<SentryException> getExceptions() {
        return this.exception == null ? null : this.exception.getValues();
    }

    public void setExceptions(@Nullable List<SentryException> exception) {
        this.exception = new SentryValues<SentryException>(exception);
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(@Nullable String transaction) {
        this.transaction = transaction;
    }

    @Nullable
    public List<String> getFingerprints() {
        return this.fingerprint;
    }

    public void setFingerprints(@Nullable List<String> fingerprint) {
        this.fingerprint = fingerprint != null ? new ArrayList<String>(fingerprint) : null;
    }

    @Override
    public void acceptUnknownProperties(@NotNull Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Nullable
    Map<String, String> getModules() {
        return this.modules;
    }

    public void setModules(@Nullable Map<String, String> modules) {
        this.modules = CollectionUtils.newHashMap(modules);
    }

    public void setModule(@NotNull String key, @NotNull String value) {
        if (this.modules == null) {
            this.modules = new HashMap<String, String>();
        }
        this.modules.put(key, value);
    }

    public void removeModule(@NotNull String key) {
        if (this.modules != null) {
            this.modules.remove(key);
        }
    }

    @Nullable
    public String getModule(@NotNull String key) {
        if (this.modules != null) {
            return this.modules.get(key);
        }
        return null;
    }

    @Nullable
    public DebugMeta getDebugMeta() {
        return this.debugMeta;
    }

    public void setDebugMeta(@Nullable DebugMeta debugMeta) {
        this.debugMeta = debugMeta;
    }

    public boolean isCrashed() {
        if (this.exception != null) {
            for (SentryException e : this.exception.getValues()) {
                if (e.getMechanism() == null || e.getMechanism().isHandled() == null || e.getMechanism().isHandled().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isErrored() {
        return this.exception != null && !this.exception.getValues().isEmpty();
    }
}

