/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.DateUtils;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.ISpan;
import com.getmati.mati_sdk.sentry.io.sentry.SentryTraceHeader;
import com.getmati.mati_sdk.sentry.io.sentry.SentryTracer;
import com.getmati.mati_sdk.sentry.io.sentry.SpanContext;
import com.getmati.mati_sdk.sentry.io.sentry.SpanId;
import com.getmati.mati_sdk.sentry.io.sentry.SpanStatus;
import com.getmati.mati_sdk.sentry.io.sentry.TransactionContext;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Span
implements ISpan {
    @NotNull
    private final Date startTimestamp;
    @Nullable
    private Date timestamp;
    @NotNull
    private final SpanContext context;
    @NotNull
    private final SentryTracer transaction;
    @Nullable
    private Throwable throwable;
    @NotNull
    private final IHub hub;
    @NotNull
    private final AtomicBoolean finished = new AtomicBoolean(false);

    Span(@NotNull SentryId traceId, @Nullable SpanId parentSpanId, @NotNull SentryTracer transaction, @NotNull String operation, @NotNull IHub hub) {
        this.context = new SpanContext(traceId, new SpanId(), operation, parentSpanId, transaction.isSampled());
        this.transaction = Objects.requireNonNull(transaction, "transaction is required");
        this.startTimestamp = DateUtils.getCurrentDateTime();
        this.hub = Objects.requireNonNull(hub, "hub is required");
    }

    Span(@NotNull TransactionContext context, @NotNull SentryTracer sentryTracer, @NotNull IHub hub) {
        this.context = Objects.requireNonNull(context, "context is required");
        this.transaction = Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.hub = Objects.requireNonNull(hub, "hub is required");
        this.startTimestamp = DateUtils.getCurrentDateTime();
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return this.transaction.startChild(this.context.getSpanId(), operation, description);
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return new SentryTraceHeader(this.context.getTraceId(), this.context.getSpanId(), this.context.getSampled());
    }

    @Override
    public void finish() {
        this.finish(this.context.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.context.setStatus(status);
        this.timestamp = DateUtils.getCurrentDateTime();
        if (this.throwable != null) {
            this.hub.setSpanContext(this.throwable, this, this.transaction.getName());
        }
    }

    @Override
    public void setOperation(@NotNull String operation) {
        this.context.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.context.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        this.context.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.context.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        this.context.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.context.getStatus();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        this.context.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.context.getTags().get(key);
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @Nullable
    public Boolean isSampled() {
        return this.context.getSampled();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.context.getTraceId();
    }

    @NotNull
    public SpanId getSpanId() {
        return this.context.getSpanId();
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.context.getParentSpanId();
    }

    public Map<String, String> getTags() {
        return this.context.getTags();
    }
}

