/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.SpanId;
import com.getmati.mati_sdk.sentry.io.sentry.SpanStatus;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.getmati.mati_sdk.sentry.io.sentry.util.CollectionUtils;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpanContext {
    public static final String TYPE = "trace";
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private final SpanId parentSpanId;
    @Nullable
    private transient Boolean sampled;
    @NotNull
    protected String op;
    @Nullable
    protected String description;
    @Nullable
    protected SpanStatus status;
    @NotNull
    protected Map<String, String> tags = new ConcurrentHashMap<String, String>();

    public SpanContext(@NotNull String operation, @Nullable Boolean sampled) {
        this(new SentryId(), new SpanId(), operation, null, sampled);
    }

    public SpanContext(@NotNull String operation) {
        this(new SentryId(), new SpanId(), operation, null, null);
    }

    public SpanContext(@NotNull SentryId traceId, @NotNull SpanId spanId, @NotNull String operation, @Nullable SpanId parentSpanId, @Nullable Boolean sampled) {
        this.traceId = Objects.requireNonNull(traceId, "traceId is required");
        this.spanId = Objects.requireNonNull(spanId, "spanId is required");
        this.op = Objects.requireNonNull(operation, "operation is required");
        this.parentSpanId = parentSpanId;
        this.sampled = sampled;
    }

    public SpanContext(@NotNull SpanContext spanContext) {
        this.traceId = spanContext.traceId;
        this.spanId = spanContext.spanId;
        this.parentSpanId = spanContext.parentSpanId;
        this.sampled = spanContext.sampled;
        this.op = spanContext.op;
        this.description = spanContext.description;
        this.status = spanContext.status;
        Map<String, String> copiedTags = CollectionUtils.newConcurrentHashMap(spanContext.tags);
        if (copiedTags != null) {
            this.tags = copiedTags;
        }
    }

    public void setOperation(@NotNull String operation) {
        this.op = Objects.requireNonNull(operation, "operation is required");
    }

    public void setTag(@NotNull String name, @NotNull String value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.tags.put(name, value);
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setStatus(@Nullable SpanStatus status) {
        this.status = status;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    public SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    @NotNull
    public String getOperation() {
        return this.op;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SpanStatus getStatus() {
        return this.status;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Nullable
    public Boolean getSampled() {
        return this.sampled;
    }

    void setSampled(@Nullable Boolean sampled) {
        this.sampled = sampled;
    }
}

