/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.SamplingContext;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

final class TracesSampler {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Random random;

    public TracesSampler(@NotNull SentryOptions options) {
        this(Objects.requireNonNull(options, "options are required"), new Random());
    }

    TracesSampler(@NotNull SentryOptions options, @NotNull Random random) {
        this.options = options;
        this.random = random;
    }

    boolean sample(@NotNull SamplingContext samplingContext) {
        Double samplerResult;
        if (samplingContext.getTransactionContext().getSampled() != null) {
            return samplingContext.getTransactionContext().getSampled();
        }
        if (this.options.getTracesSampler() != null && (samplerResult = this.options.getTracesSampler().sample(samplingContext)) != null) {
            return this.sample(samplerResult);
        }
        if (samplingContext.getTransactionContext().getParentSampled() != null) {
            return samplingContext.getTransactionContext().getParentSampled();
        }
        if (this.options.getTracesSampleRate() != null) {
            return this.sample(this.options.getTracesSampleRate());
        }
        return false;
    }

    private boolean sample(@NotNull Double aDouble) {
        return !(aDouble < this.random.nextDouble());
    }
}

