/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.adapters;

import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.SpanContext;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.App;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Browser;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Contexts;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Device;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Gpu;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.OperatingSystem;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryRuntime;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextsDeserializerAdapter
implements JsonDeserializer<Contexts> {
    @NotNull
    private final SentryOptions options;

    public ContextsDeserializerAdapter(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Nullable
    public Contexts deserialize(@Nullable JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        try {
            if (json2 != null && !json2.isJsonNull()) {
                Contexts contexts = new Contexts();
                JsonObject jsonObject = json2.getAsJsonObject();
                if (jsonObject != null && !jsonObject.isJsonNull()) {
                    Iterator iterator = jsonObject.keySet().iterator();
                    block22: while (iterator.hasNext()) {
                        String key;
                        switch (key = (String)iterator.next()) {
                            case "app": {
                                App app = this.parseObject(context, jsonObject, key, App.class);
                                if (app == null) continue block22;
                                contexts.setApp(app);
                                continue block22;
                            }
                            case "browser": {
                                Browser browser = this.parseObject(context, jsonObject, key, Browser.class);
                                if (browser == null) continue block22;
                                contexts.setBrowser(browser);
                                continue block22;
                            }
                            case "device": {
                                Device device = this.parseObject(context, jsonObject, key, Device.class);
                                if (device == null) continue block22;
                                contexts.setDevice(device);
                                continue block22;
                            }
                            case "os": {
                                OperatingSystem os = this.parseObject(context, jsonObject, key, OperatingSystem.class);
                                if (os == null) continue block22;
                                contexts.setOperatingSystem(os);
                                continue block22;
                            }
                            case "runtime": {
                                SentryRuntime runtime = this.parseObject(context, jsonObject, key, SentryRuntime.class);
                                if (runtime == null) continue block22;
                                contexts.setRuntime(runtime);
                                continue block22;
                            }
                            case "gpu": {
                                Gpu gpu = this.parseObject(context, jsonObject, key, Gpu.class);
                                if (gpu == null) continue block22;
                                contexts.setGpu(gpu);
                                continue block22;
                            }
                            case "trace": {
                                SpanContext trace = this.parseObject(context, jsonObject, key, SpanContext.class);
                                if (trace == null) continue block22;
                                contexts.setTrace(trace);
                                continue block22;
                            }
                        }
                        JsonElement element = jsonObject.get(key);
                        if (element == null || element.isJsonNull()) continue;
                        try {
                            Object object = context.deserialize(element, Object.class);
                            contexts.put(key, object);
                        }
                        catch (JsonParseException e) {
                            this.options.getLogger().log(SentryLevel.ERROR, e, "Error when deserializing the %s key.", key);
                        }
                    }
                }
                return contexts;
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing Contexts", e);
        }
        return null;
    }

    @Nullable
    private <T> T parseObject(@NotNull JsonDeserializationContext context, @NotNull JsonObject jsonObject, @NotNull String key, @NotNull Class<T> clazz) throws JsonParseException {
        JsonObject object = jsonObject.getAsJsonObject(key);
        if (object != null && !object.isJsonNull()) {
            return (T)context.deserialize((JsonElement)object, clazz);
        }
        return null;
    }
}

