/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.adapters;

import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Contexts;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextsSerializerAdapter
implements JsonSerializer<Contexts> {
    @NotNull
    private final SentryOptions options;

    public ContextsSerializerAdapter(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Nullable
    public JsonElement serialize(@Nullable Contexts src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        JsonObject object = new JsonObject();
        for (Map.Entry entry : src.entrySet()) {
            try {
                JsonElement element = context.serialize(entry.getValue(), Object.class);
                if (element == null) continue;
                object.add((String)entry.getKey(), element);
            }
            catch (JsonParseException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "%s context key isn't serializable.", new Object[0]);
            }
        }
        return object;
    }
}

