/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.adapters;

import com.getmati.mati_sdk.sentry.io.sentry.DateUtils;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DateDeserializerAdapter
implements JsonDeserializer<Date> {
    @NotNull
    private final SentryOptions options;

    public DateDeserializerAdapter(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Nullable
    public Date deserialize(@Nullable JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        try {
            return json2 == null ? null : DateUtils.getDateTime(json2.getAsString());
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Error when deserializing UTC timestamp format, it might be millis timestamp format.", e);
            try {
                return DateUtils.getDateTimeWithMillisPrecision(json2.getAsString());
            }
            catch (Exception e2) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing millis timestamp format.", e2);
                return null;
            }
        }
    }
}

