/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.ApplicationNotResponding;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.IHandler;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.MainLooperHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

final class ANRWatchDog
extends Thread {
    private final boolean reportInDebug;
    private final ANRListener anrListener;
    private final IHandler uiHandler;
    private final long timeoutIntervalMillis;
    @NotNull
    private final ILogger logger;
    private final AtomicLong tick = new AtomicLong(0L);
    private final AtomicBoolean reported = new AtomicBoolean(false);
    @NotNull
    private final Context context;
    private final Runnable ticker = () -> {
        this.tick.set(0L);
        this.reported.set(false);
    };

    ANRWatchDog(long timeoutIntervalMillis, boolean reportInDebug, @NotNull ANRListener listener, @NotNull ILogger logger, @NotNull Context context) {
        this(timeoutIntervalMillis, reportInDebug, listener, logger, new MainLooperHandler(), context);
    }

    ANRWatchDog(long timeoutIntervalMillis, boolean reportInDebug, @NotNull ANRListener listener, @NotNull ILogger logger, @NotNull IHandler uiHandler, @NotNull Context context) {
        this.reportInDebug = reportInDebug;
        this.anrListener = listener;
        this.timeoutIntervalMillis = timeoutIntervalMillis;
        this.logger = logger;
        this.uiHandler = uiHandler;
        this.context = context;
    }

    @Override
    public void run() {
        this.setName("|ANR-WatchDog|");
        long interval = this.timeoutIntervalMillis;
        while (!this.isInterrupted()) {
            boolean needPost = this.tick.get() == 0L;
            this.tick.addAndGet(interval);
            if (needPost) {
                this.uiHandler.post(this.ticker);
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(SentryLevel.WARNING, "Interrupted: %s", e.getMessage());
                return;
            }
            if (this.tick.get() == 0L || this.reported.get()) continue;
            if (!this.reportInDebug && (Debug.isDebuggerConnected() || Debug.waitingForDebugger())) {
                this.logger.log(SentryLevel.DEBUG, "An ANR was detected but ignored because the debugger is connected.", new Object[0]);
                this.reported.set(true);
                continue;
            }
            ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
            if (am != null) {
                List processesInErrorState = am.getProcessesInErrorState();
                if (processesInErrorState == null) continue;
                boolean isAnr = false;
                for (ActivityManager.ProcessErrorStateInfo item : processesInErrorState) {
                    if (item.condition != 2) continue;
                    isAnr = true;
                    break;
                }
                if (!isAnr) continue;
            }
            this.logger.log(SentryLevel.INFO, "Raising ANR", new Object[0]);
            String message = "Application Not Responding for at least " + this.timeoutIntervalMillis + " ms.";
            ApplicationNotResponding error = new ApplicationNotResponding(message, this.uiHandler.getThread());
            this.anrListener.onAppNotResponding(error);
            interval = this.timeoutIntervalMillis;
            this.reported.set(true);
        }
    }

    public static interface ANRListener {
        public void onAppNotResponding(@NotNull ApplicationNotResponding var1);
    }
}

