/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getmati.mati_sdk.sentry.io.sentry.Breadcrumb;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.ITransaction;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.Scope;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.SpanStatus;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.IBuildInfoProvider;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Application application;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    private boolean isAllActivityCallbacksAvailable;
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();

    public ActivityLifecycleIntegration(@NotNull Application application, @NotNull IBuildInfoProvider buildInfoProvider) {
        this.application = Objects.requireNonNull(application, "Application is required");
        Objects.requireNonNull(buildInfoProvider, "BuildInfoProvider is required");
        if (buildInfoProvider.getSdkInfoVersion() >= 29) {
            this.isAllActivityCallbacksAvailable = true;
        }
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null, "SentryAndroidOptions is required");
        this.hub = Objects.requireNonNull(hub, "Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration enabled: %s", this.options.isEnableActivityLifecycleBreadcrumbs());
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        if (this.options.isEnableActivityLifecycleBreadcrumbs() || this.performanceEnabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
        }
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return options.isTracingEnabled() && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
        }
    }

    private void addBreadcrumb(@NonNull Activity activity, @NotNull String state) {
        if (this.options != null && this.hub != null && this.options.isEnableActivityLifecycleBreadcrumbs()) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", state);
            breadcrumb.setData("screen", this.getActivityName(activity));
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    @NotNull
    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            this.finishTransaction(transaction);
        }
    }

    private void startTracing(@NonNull Activity activity) {
        if (this.performanceEnabled && !this.isRunningTransaction(activity) && this.hub != null) {
            this.stopPreviousTransactions();
            ITransaction transaction = this.hub.startTransaction(this.getActivityName(activity), "navigation");
            this.hub.configureScope(scope -> this.applyScope(scope, transaction));
            this.activitiesWithOngoingTransactions.put(activity, transaction);
        }
    }

    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", transaction.getName());
            }
        });
    }

    private boolean isRunningTransaction(@NonNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NonNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction) {
        if (transaction != null) {
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
        }
    }

    public synchronized void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (this.isAllActivityCallbacksAvailable) {
            this.startTracing(activity);
        }
    }

    public synchronized void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.addBreadcrumb(activity, "created");
        if (!this.isAllActivityCallbacksAvailable) {
            this.startTracing(activity);
        }
    }

    public synchronized void onActivityStarted(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "started");
    }

    public synchronized void onActivityResumed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "resumed");
        if (!this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPostResumed(@NonNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPaused(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
        this.stopTracing(activity, true);
        if (this.performanceEnabled) {
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }
}

