/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.util.Log;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidLogger
implements ILogger {
    private static final String tag = "Sentry";

    AndroidLogger() {
    }

    @Override
    public void log(@NotNull SentryLevel level, @NotNull String message, Object ... args) {
        Log.println((int)this.toLogcatLevel(level), (String)tag, (String)String.format(message, args));
    }

    @Override
    public void log(@NotNull SentryLevel level, @Nullable Throwable throwable, @NotNull String message, Object ... args) {
        this.log(level, String.format(message, args), throwable);
    }

    @Override
    public void log(@NotNull SentryLevel level, @NotNull String message, @Nullable Throwable throwable) {
        switch (level) {
            case INFO: {
                Log.i((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case WARNING: {
                Log.w((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case ERROR: {
                Log.e((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            case FATAL: {
                Log.wtf((String)tag, (String)message, (Throwable)throwable);
                break;
            }
            default: {
                Log.d((String)tag, (String)message, (Throwable)throwable);
            }
        }
    }

    @Override
    public boolean isEnabled(@Nullable SentryLevel level) {
        return true;
    }

    private int toLogcatLevel(@NotNull SentryLevel sentryLevel) {
        switch (sentryLevel) {
            case INFO: {
                return 4;
            }
            case WARNING: {
                return 5;
            }
            case FATAL: {
                return 7;
            }
        }
        return 3;
    }
}

