/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.SendFireAndForgetEnvelopeSender;
import com.getmati.mati_sdk.sentry.io.sentry.SendFireAndForgetOutboxSender;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.ActivityLifecycleIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AndroidLogger;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AndroidTransportGate;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AnrIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AppComponentsBreadcrumbsIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AppLifecycleIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.BuildInfoProvider;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.ContextUtils;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.DefaultAndroidEventProcessor;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.EnvelopeFileObserverIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.IBuildInfoProvider;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.ILoadClass;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.Installation;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.LoadClass;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.NdkIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.PhoneStateBreadcrumbsIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SystemEventsBreadcrumbsIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.TempSensorBreadcrumbsIntegration;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidOptionsInitializer {
    private AndroidOptionsInitializer() {
    }

    public static void init(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        Objects.requireNonNull(context, "The application context is required.");
        Objects.requireNonNull(options, "The options object is required.");
        AndroidOptionsInitializer.init(options, context, new AndroidLogger());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger) {
        AndroidOptionsInitializer.init(options, context, logger, new BuildInfoProvider());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider) {
        AndroidOptionsInitializer.init(options, context, logger, buildInfoProvider, new LoadClass());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ILoadClass loadClass) {
        Objects.requireNonNull(context, "The context is required.");
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        Objects.requireNonNull(options, "The options object is required.");
        Objects.requireNonNull(logger, "The ILogger object is required.");
        options.setLogger(logger);
        options.setDsn("https://32cd461009cf4a43a1a0721c5855dc17@o566293.ingest.sentry.io/5708944");
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        AndroidOptionsInitializer.installDefaultIntegrations(context, options, buildInfoProvider, loadClass);
        AndroidOptionsInitializer.readDefaultOptionValues(options, context);
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, logger, buildInfoProvider));
        options.setTransportGate(new AndroidTransportGate(context, options.getLogger()));
    }

    private static void installDefaultIntegrations(@NotNull Context context, @NotNull SentryOptions options, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ILoadClass loadClass) {
        options.addIntegration(new SendCachedEnvelopeFireAndForgetIntegration(new SendFireAndForgetEnvelopeSender(() -> options.getCacheDirPath())));
        Class<?> sentryNdkClass = AndroidOptionsInitializer.loadNdkIfAvailable(options, buildInfoProvider, loadClass);
        options.addIntegration(new NdkIntegration(sentryNdkClass));
        options.addIntegration(EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration(new SendCachedEnvelopeFireAndForgetIntegration(new SendFireAndForgetOutboxSender(() -> options.getOutboxPath())));
        options.addIntegration(new AnrIntegration(context));
        options.addIntegration(new AppLifecycleIntegration());
        if (context instanceof Application) {
            options.addIntegration(new ActivityLifecycleIntegration((Application)context, buildInfoProvider));
        } else {
            options.getLogger().log(SentryLevel.WARNING, "ActivityBreadcrumbsIntegration needs an Application class to be installed.", new Object[0]);
        }
        options.addIntegration(new AppComponentsBreadcrumbsIntegration(context));
        options.addIntegration(new SystemEventsBreadcrumbsIntegration(context));
        options.addIntegration(new TempSensorBreadcrumbsIntegration(context));
        options.addIntegration(new PhoneStateBreadcrumbsIntegration(context));
    }

    private static void readDefaultOptionValues(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(context, options.getLogger());
        if (packageInfo != null) {
            String packageName;
            if (options.getRelease() == null) {
                options.setRelease(AndroidOptionsInitializer.getSentryReleaseVersion(packageInfo, ContextUtils.getVersionCode(packageInfo)));
            }
            if ((packageName = packageInfo.packageName) != null && !packageName.startsWith("android.")) {
                options.addInAppInclude(packageName);
            }
        }
        if (options.getDistinctId() == null) {
            try {
                options.setDistinctId(Installation.id(context));
            }
            catch (RuntimeException e) {
                options.getLogger().log(SentryLevel.ERROR, "Could not generate distinct Id.", e);
            }
        }
    }

    @NotNull
    private static String getSentryReleaseVersion(@NotNull PackageInfo packageInfo, @NotNull String versionCode) {
        return packageInfo.packageName + "@" + packageInfo.versionName + "+" + versionCode;
    }

    private static void initializeCacheDirs(@NotNull Context context, @NotNull SentryOptions options) {
        File cacheDir = new File(context.getCacheDir(), "mati_sentry");
        options.setCacheDirPath(cacheDir.getAbsolutePath());
    }

    private static boolean isNdkAvailable(@NotNull IBuildInfoProvider buildInfoProvider) {
        return buildInfoProvider.getSdkInfoVersion() >= 16;
    }

    @Nullable
    private static Class<?> loadNdkIfAvailable(@NotNull SentryOptions options, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull ILoadClass loadClass) {
        if (AndroidOptionsInitializer.isNdkAvailable(buildInfoProvider)) {
            try {
                return loadClass.loadClass("io.sentry.android.ndk.SentryNdk");
            }
            catch (ClassNotFoundException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to load SentryNdk.", e);
            }
            catch (UnsatisfiedLinkError e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to load (UnsatisfiedLinkError) SentryNdk.", e);
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", e);
            }
        }
        return null;
    }
}

