/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getmati.mati_sdk.sentry.io.sentry.Breadcrumb;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.util.DeviceOrientations;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Device;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class AppComponentsBreadcrumbsIntegration
implements Integration,
Closeable,
ComponentCallbacks2 {
    @NotNull
    private final Context context;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;

    public AppComponentsBreadcrumbsIntegration(@NotNull Context context) {
        this.context = Objects.requireNonNull(context, "Context is required");
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.hub = Objects.requireNonNull(hub, "Hub is required");
        this.options = Objects.requireNonNull(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null, "SentryAndroidOptions is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration enabled: %s", this.options.isEnableAppComponentBreadcrumbs());
        if (this.options.isEnableAppComponentBreadcrumbs()) {
            try {
                this.context.registerComponentCallbacks((ComponentCallbacks)this);
                options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration installed.", new Object[0]);
            }
            catch (Exception e) {
                this.options.setEnableAppComponentBreadcrumbs(false);
                options.getLogger().log(SentryLevel.INFO, e, "ComponentCallbacks2 is not available.", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration removed.", new Object[0]);
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        if (this.hub != null) {
            Device.DeviceOrientation deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            String orientation = deviceOrientation != null ? deviceOrientation.name().toLowerCase(Locale.ROOT) : "undefined";
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setCategory("device.orientation");
            breadcrumb.setData("position", orientation);
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    public void onLowMemory() {
        this.createLowMemoryBreadcrumb(null);
    }

    public void onTrimMemory(int level) {
        this.createLowMemoryBreadcrumb(level);
    }

    private void createLowMemoryBreadcrumb(@Nullable Integer level) {
        if (this.hub != null) {
            Breadcrumb breadcrumb = new Breadcrumb();
            if (level != null) {
                if (level < 40) {
                    return;
                }
                breadcrumb.setData("level", level);
            }
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            breadcrumb.setMessage("Low memory");
            breadcrumb.setData("action", "LOW_MEMORY");
            breadcrumb.setLevel(SentryLevel.WARNING);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }
}

