/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.IHandler;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.LifecycleWatcher;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.MainLooperHandler;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.util.MainThreadChecker;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppLifecycleIntegration
implements Integration,
Closeable {
    @Nullable
    LifecycleWatcher watcher;
    @Nullable
    private SentryAndroidOptions options;
    @NotNull
    private final IHandler handler;

    public AppLifecycleIntegration() {
        this(new MainLooperHandler());
    }

    AppLifecycleIntegration(@NotNull IHandler handler) {
        this.handler = handler;
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        this.options = Objects.requireNonNull(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null, "SentryAndroidOptions is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSessionTracking enabled: %s", this.options.isEnableAutoSessionTracking());
        this.options.getLogger().log(SentryLevel.DEBUG, "enableAppLifecycleBreadcrumbs enabled: %s", this.options.isEnableAppLifecycleBreadcrumbs());
        if (this.options.isEnableAutoSessionTracking() || this.options.isEnableAppLifecycleBreadcrumbs()) {
            try {
                Class.forName("androidx.lifecycle.DefaultLifecycleObserver");
                Class.forName("androidx.lifecycle.ProcessLifecycleOwner");
                if (MainThreadChecker.isMainThread()) {
                    this.addObserver(hub);
                } else {
                    this.handler.post(() -> this.addObserver(hub));
                }
            }
            catch (ClassNotFoundException e) {
                options.getLogger().log(SentryLevel.INFO, "androidx.lifecycle is not available, AppLifecycleIntegration won't be installed", e);
            }
            catch (IllegalStateException e) {
                options.getLogger().log(SentryLevel.ERROR, "AppLifecycleIntegration could not be installed", e);
            }
        }
    }

    private void addObserver(@NotNull IHub hub) {
        if (this.options == null) {
            return;
        }
        this.watcher = new LifecycleWatcher(hub, this.options.getSessionTrackingIntervalMillis(), this.options.isEnableAutoSessionTracking(), this.options.isEnableAppLifecycleBreadcrumbs());
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.watcher);
        this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration installed.", new Object[0]);
    }

    private void removeObserver() {
        ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this.watcher);
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            if (MainThreadChecker.isMainThread()) {
                this.removeObserver();
            } else {
                this.handler.post(() -> this.removeObserver());
            }
            this.watcher = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration removed.", new Object[0]);
            }
        }
    }
}

