/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.os.FileObserver;
import com.getmati.mati_sdk.sentry.io.sentry.IEnvelopeSender;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.hints.ApplyScopeData;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Cached;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Flushable;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Resettable;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Retryable;
import com.getmati.mati_sdk.sentry.io.sentry.hints.SubmissionResult;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnvelopeFileObserver
extends FileObserver {
    private final String rootPath;
    private final IEnvelopeSender envelopeSender;
    @NotNull
    private final ILogger logger;
    private final long flushTimeoutMillis;

    EnvelopeFileObserver(String path2, IEnvelopeSender envelopeSender, @NotNull ILogger logger, long flushTimeoutMillis) {
        super(path2);
        this.rootPath = Objects.requireNonNull(path2, "File path is required.");
        this.envelopeSender = Objects.requireNonNull(envelopeSender, "Envelope sender is required.");
        this.logger = Objects.requireNonNull(logger, "Logger is required.");
        this.flushTimeoutMillis = flushTimeoutMillis;
    }

    public void onEvent(int eventType, @Nullable String relativePath) {
        if (relativePath == null || eventType != 8) {
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "onEvent fired for EnvelopeFileObserver with event type %d on path: %s for file %s.", eventType, this.rootPath, relativePath);
        CachedEnvelopeHint hint = new CachedEnvelopeHint(this.flushTimeoutMillis, this.logger);
        this.envelopeSender.processEnvelopeFile(this.rootPath + File.separator + relativePath, hint);
    }

    private static final class CachedEnvelopeHint
    implements Cached,
    Retryable,
    SubmissionResult,
    Flushable,
    ApplyScopeData,
    Resettable {
        boolean retry;
        boolean succeeded;
        @NotNull
        private CountDownLatch latch;
        private final long flushTimeoutMillis;
        @NotNull
        private final ILogger logger;

        public CachedEnvelopeHint(long flushTimeoutMillis, @NotNull ILogger logger) {
            this.reset();
            this.flushTimeoutMillis = flushTimeoutMillis;
            this.logger = Objects.requireNonNull(logger, "ILogger is required.");
        }

        @Override
        public boolean waitFlush() {
            try {
                return this.latch.await(this.flushTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(SentryLevel.ERROR, "Exception while awaiting on lock.", e);
                return false;
            }
        }

        @Override
        public boolean isRetry() {
            return this.retry;
        }

        @Override
        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        @Override
        public void setResult(boolean succeeded) {
            this.succeeded = succeeded;
            this.latch.countDown();
        }

        @Override
        public boolean isSuccess() {
            return this.succeeded;
        }

        @Override
        public void reset() {
            this.latch = new CountDownLatch(1);
            this.retry = false;
            this.succeeded = false;
        }
    }
}

