/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.OutboxSender;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.EnvelopeFileObserver;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnvelopeFileObserverIntegration
implements Integration,
Closeable {
    @Nullable
    private EnvelopeFileObserver observer;
    @Nullable
    private ILogger logger;

    @NotNull
    public static EnvelopeFileObserverIntegration getOutboxFileObserver() {
        return new OutboxEnvelopeFileObserverIntegration();
    }

    @Override
    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        Objects.requireNonNull(options, "SentryOptions is required");
        this.logger = options.getLogger();
        String path2 = this.getPath(options);
        if (path2 == null) {
            this.logger.log(SentryLevel.WARNING, "Null given as a path to EnvelopeFileObserverIntegration. Nothing will be registered.", new Object[0]);
        } else {
            this.logger.log(SentryLevel.DEBUG, "Registering EnvelopeFileObserverIntegration for path: %s", path2);
            OutboxSender outboxSender = new OutboxSender(hub, options.getEnvelopeReader(), options.getSerializer(), this.logger, options.getFlushTimeoutMillis());
            this.observer = new EnvelopeFileObserver(path2, outboxSender, this.logger, options.getFlushTimeoutMillis());
            this.observer.startWatching();
            this.logger.log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration installed.", new Object[0]);
        }
    }

    @Override
    public void close() {
        if (this.observer != null) {
            this.observer.stopWatching();
            if (this.logger != null) {
                this.logger.log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration removed.", new Object[0]);
            }
        }
    }

    @Nullable
    abstract String getPath(@NotNull SentryOptions var1);

    private static final class OutboxEnvelopeFileObserverIntegration
    extends EnvelopeFileObserverIntegration {
        private OutboxEnvelopeFileObserverIntegration() {
        }

        @Override
        @Nullable
        protected String getPath(@NotNull SentryOptions options) {
            return options.getOutboxPath();
        }
    }
}

