/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.content.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Installation {
    @Nullable
    static String deviceId = null;
    static final String INSTALLATION = "INSTALLATION";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private Installation() {
    }

    public static synchronized String id(@NotNull Context context) throws RuntimeException {
        if (deviceId == null) {
            File installation = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (!installation.exists()) {
                    deviceId = Installation.writeInstallationFile(installation);
                    return deviceId;
                }
                deviceId = Installation.readInstallationFile(installation);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return deviceId;
    }

    @NotNull
    static String readInstallationFile(@NotNull File installation) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(installation, "r");){
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            String string = new String(bytes, UTF_8);
            return string;
        }
    }

    @NotNull
    static String writeInstallationFile(@NotNull File installation) throws IOException {
        try (FileOutputStream out = new FileOutputStream(installation);){
            String id2 = UUID.randomUUID().toString();
            ((OutputStream)out).write(id2.getBytes(UTF_8));
            out.flush();
            String string = id2;
            return string;
        }
    }
}

