/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ManifestMetadataReader {
    static final String DSN = "io.sentry.dsn";
    static final String DEBUG = "io.sentry.debug";
    static final String DEBUG_LEVEL = "io.sentry.debug.level";
    static final String SAMPLE_RATE = "io.sentry.sample-rate";
    static final String ANR_ENABLE = "io.sentry.anr.enable";
    static final String ANR_REPORT_DEBUG = "io.sentry.anr.report-debug";
    static final String ANR_TIMEOUT_INTERVAL_MILLIS = "io.sentry.anr.timeout-interval-millis";
    static final String AUTO_INIT = "io.sentry.auto-init";
    static final String NDK_ENABLE = "io.sentry.ndk.enable";
    static final String NDK_SCOPE_SYNC_ENABLE = "io.sentry.ndk.scope-sync.enable";
    static final String RELEASE = "io.sentry.release";
    static final String ENVIRONMENT = "io.sentry.environment";
    static final String SESSION_TRACKING_ENABLE = "io.sentry.session-tracking.enable";
    static final String AUTO_SESSION_TRACKING_ENABLE = "io.sentry.auto-session-tracking.enable";
    static final String SESSION_TRACKING_TIMEOUT_INTERVAL_MILLIS = "io.sentry.session-tracking.timeout-interval-millis";
    static final String BREADCRUMBS_ACTIVITY_LIFECYCLE_ENABLE = "io.sentry.breadcrumbs.activity-lifecycle";
    static final String BREADCRUMBS_APP_LIFECYCLE_ENABLE = "io.sentry.breadcrumbs.app-lifecycle";
    static final String BREADCRUMBS_SYSTEM_EVENTS_ENABLE = "io.sentry.breadcrumbs.system-events";
    static final String BREADCRUMBS_APP_COMPONENTS_ENABLE = "io.sentry.breadcrumbs.app-components";
    static final String UNCAUGHT_EXCEPTION_HANDLER_ENABLE = "io.sentry.uncaught-exception-handler.enable";
    static final String TRACES_SAMPLE_RATE = "io.sentry.traces.sample-rate";
    static final String TRACES_ACTIVITY_ENABLE = "io.sentry.traces.activity.enable";
    static final String TRACES_ACTIVITY_AUTO_FINISH_ENABLE = "io.sentry.traces.activity.auto-finish.enable";
    static final String ATTACH_THREADS = "io.sentry.attach-threads";

    private ManifestMetadataReader() {
    }

    static void applyMetadata(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        Objects.requireNonNull(context, "The application context is required.");
        Objects.requireNonNull(options, "The options object is required.");
        try {
            Bundle metadata2 = ManifestMetadataReader.getMetadata(context);
            ILogger logger = options.getLogger();
            if (metadata2 != null) {
                Double tracesSampleRate;
                Double sampleRate;
                String level;
                options.setDebug(ManifestMetadataReader.readBool(metadata2, logger, DEBUG, options.isDebug()));
                if (options.isDebug() && (level = ManifestMetadataReader.readString(metadata2, logger, DEBUG_LEVEL, options.getDiagnosticLevel().name().toLowerCase(Locale.ROOT))) != null) {
                    options.setDiagnosticLevel(SentryLevel.valueOf(level.toUpperCase(Locale.ROOT)));
                }
                options.setAnrEnabled(ManifestMetadataReader.readBool(metadata2, logger, ANR_ENABLE, options.isAnrEnabled()));
                boolean enableSessionTracking = ManifestMetadataReader.readBool(metadata2, logger, SESSION_TRACKING_ENABLE, options.isEnableAutoSessionTracking());
                options.setEnableAutoSessionTracking(ManifestMetadataReader.readBool(metadata2, logger, AUTO_SESSION_TRACKING_ENABLE, enableSessionTracking));
                if (options.getSampleRate() == null && (sampleRate = ManifestMetadataReader.readDouble(metadata2, logger, SAMPLE_RATE)) != -1.0) {
                    options.setSampleRate(sampleRate);
                }
                options.setAnrReportInDebug(ManifestMetadataReader.readBool(metadata2, logger, ANR_REPORT_DEBUG, options.isAnrReportInDebug()));
                options.setAnrTimeoutIntervalMillis(ManifestMetadataReader.readLong(metadata2, logger, ANR_TIMEOUT_INTERVAL_MILLIS, options.getAnrTimeoutIntervalMillis()));
                String dsn = ManifestMetadataReader.readString(metadata2, logger, DSN, options.getDsn());
                if (dsn == null) {
                    options.getLogger().log(SentryLevel.FATAL, "DSN is required. Use empty string to disable SDK.", new Object[0]);
                } else if (dsn.isEmpty()) {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN is empty, disabling sentry-android", new Object[0]);
                }
                options.setDsn(dsn);
                options.setEnableNdk(ManifestMetadataReader.readBool(metadata2, logger, NDK_ENABLE, options.isEnableNdk()));
                options.setEnableScopeSync(ManifestMetadataReader.readBool(metadata2, logger, NDK_SCOPE_SYNC_ENABLE, options.isEnableScopeSync()));
                options.setRelease(ManifestMetadataReader.readString(metadata2, logger, RELEASE, options.getRelease()));
                options.setEnvironment(ManifestMetadataReader.readString(metadata2, logger, ENVIRONMENT, options.getEnvironment()));
                options.setSessionTrackingIntervalMillis(ManifestMetadataReader.readLong(metadata2, logger, SESSION_TRACKING_TIMEOUT_INTERVAL_MILLIS, options.getSessionTrackingIntervalMillis()));
                options.setEnableActivityLifecycleBreadcrumbs(ManifestMetadataReader.readBool(metadata2, logger, BREADCRUMBS_ACTIVITY_LIFECYCLE_ENABLE, options.isEnableActivityLifecycleBreadcrumbs()));
                options.setEnableAppLifecycleBreadcrumbs(ManifestMetadataReader.readBool(metadata2, logger, BREADCRUMBS_APP_LIFECYCLE_ENABLE, options.isEnableAppComponentBreadcrumbs()));
                options.setEnableSystemEventBreadcrumbs(ManifestMetadataReader.readBool(metadata2, logger, BREADCRUMBS_SYSTEM_EVENTS_ENABLE, options.isEnableSystemEventBreadcrumbs()));
                options.setEnableAppComponentBreadcrumbs(ManifestMetadataReader.readBool(metadata2, logger, BREADCRUMBS_APP_COMPONENTS_ENABLE, options.isEnableAppComponentBreadcrumbs()));
                options.setEnableUncaughtExceptionHandler(ManifestMetadataReader.readBool(metadata2, logger, UNCAUGHT_EXCEPTION_HANDLER_ENABLE, options.isEnableUncaughtExceptionHandler()));
                options.setAttachThreads(ManifestMetadataReader.readBool(metadata2, logger, ATTACH_THREADS, options.isAttachThreads()));
                if (options.getTracesSampleRate() == null && (tracesSampleRate = ManifestMetadataReader.readDouble(metadata2, logger, TRACES_SAMPLE_RATE)) != -1.0) {
                    options.setTracesSampleRate(tracesSampleRate);
                }
                options.setEnableAutoActivityLifecycleTracing(ManifestMetadataReader.readBool(metadata2, logger, TRACES_ACTIVITY_ENABLE, options.isEnableAutoActivityLifecycleTracing()));
                options.setEnableActivityLifecycleTracingAutoFinish(ManifestMetadataReader.readBool(metadata2, logger, TRACES_ACTIVITY_AUTO_FINISH_ENABLE, options.isEnableActivityLifecycleTracingAutoFinish()));
            }
            options.getLogger().log(SentryLevel.INFO, "Retrieving configuration from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to read configuration from android manifest metadata.", e);
        }
    }

    private static boolean readBool(@NotNull Bundle metadata2, @NotNull ILogger logger, @NotNull String key, boolean defaultValue) {
        boolean value = metadata2.getBoolean(key, defaultValue);
        logger.log(SentryLevel.DEBUG, "%s read: %s", key, value);
        return value;
    }

    @Nullable
    private static String readString(@NotNull Bundle metadata2, @NotNull ILogger logger, @NotNull String key, @Nullable String defaultValue) {
        String value = metadata2.getString(key, defaultValue);
        logger.log(SentryLevel.DEBUG, "%s read: %s", key, value);
        return value;
    }

    @NotNull
    private static Double readDouble(@NotNull Bundle metadata2, @NotNull ILogger logger, @NotNull String key) {
        Double value = Float.valueOf(metadata2.getFloat(key, -1.0f)).doubleValue();
        logger.log(SentryLevel.DEBUG, "%s read: %s", key, value);
        return value;
    }

    private static long readLong(@NotNull Bundle metadata2, @NotNull ILogger logger, @NotNull String key, long defaultValue) {
        long value = metadata2.getInt(key, (int)defaultValue);
        logger.log(SentryLevel.DEBUG, "%s read: %s", key, value);
        return value;
    }

    static boolean isAutoInit(@NotNull Context context, @NotNull ILogger logger) {
        Objects.requireNonNull(context, "The application context is required.");
        boolean autoInit = true;
        try {
            Bundle metadata2 = ManifestMetadataReader.getMetadata(context);
            if (metadata2 != null) {
                autoInit = ManifestMetadataReader.readBool(metadata2, logger, AUTO_INIT, true);
            }
            logger.log(SentryLevel.INFO, "Retrieving auto-init from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Failed to read auto-init from android manifest metadata.", e);
        }
        return autoInit;
    }

    @Nullable
    private static Bundle getMetadata(@NotNull Context context) throws PackageManager.NameNotFoundException {
        ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        return app.metaData;
    }
}

