/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NdkIntegration
implements Integration,
Closeable {
    public static final String SENTRY_NDK_CLASS_NAME = "io.sentry.android.ndk.SentryNdk";
    @Nullable
    private final Class<?> sentryNdkClass;
    @Nullable
    private SentryAndroidOptions options;

    public NdkIntegration(@Nullable Class<?> sentryNdkClass) {
        this.sentryNdkClass = sentryNdkClass;
    }

    @Override
    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        this.options = Objects.requireNonNull(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null, "SentryAndroidOptions is required");
        boolean enabled = this.options.isEnableNdk();
        this.options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration enabled: %s", enabled);
        if (enabled && this.sentryNdkClass != null) {
            String cachedDir = this.options.getCacheDirPath();
            if (cachedDir == null || cachedDir.isEmpty()) {
                this.options.getLogger().log(SentryLevel.ERROR, "No cache dir path is defined in options.", new Object[0]);
                this.options.setEnableNdk(false);
                return;
            }
            try {
                Method method = this.sentryNdkClass.getMethod("init", SentryAndroidOptions.class);
                Object[] args = new Object[]{this.options};
                method.invoke(null, args);
                this.options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration installed.", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.options.setEnableNdk(false);
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to invoke the SentryNdk.init method.", e);
            }
            catch (Throwable e) {
                this.options.setEnableNdk(false);
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", e);
            }
        } else {
            this.options.setEnableNdk(false);
        }
    }

    @Nullable
    Class<?> getSentryNdkClass() {
        return this.sentryNdkClass;
    }

    @Override
    public void close() throws IOException {
        if (this.options != null && this.options.isEnableNdk() && this.sentryNdkClass != null) {
            try {
                Method method = this.sentryNdkClass.getMethod("close", new Class[0]);
                method.invoke(null, new Object[0]);
                this.options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration removed.", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to invoke the SentryNdk.close method.", e);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to close SentryNdk.", e);
            }
            finally {
                this.options.setEnableNdk(false);
            }
        }
    }
}

