/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.content.Context;
import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.OptionsContainer;
import com.getmati.mati_sdk.sentry.io.sentry.Sentry;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AndroidLogger;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AndroidOptionsInitializer;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;

public final class SentryAndroid {
    private SentryAndroid() {
    }

    public static void init(@NotNull Context context) {
        SentryAndroid.init(context, new AndroidLogger());
    }

    public static void init(@NotNull Context context, @NotNull ILogger logger) {
        SentryAndroid.init(context, logger, options -> {});
    }

    public static void init(@NotNull Context context, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        SentryAndroid.init(context, new AndroidLogger(), configuration);
    }

    public static void init(@NotNull Context context, @NotNull ILogger logger, @NotNull Sentry.OptionsConfiguration<SentryAndroidOptions> configuration) {
        try {
            Sentry.init(OptionsContainer.create(SentryAndroidOptions.class), (T options) -> {
                AndroidOptionsInitializer.init(options, context, logger);
                configuration.configure((SentryAndroidOptions)options);
            }, true);
        }
        catch (IllegalAccessException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InstantiationException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
        catch (InvocationTargetException e) {
            logger.log(SentryLevel.FATAL, "Fatal error during SentryAndroid.init(...)", e);
            throw new RuntimeException("Failed to initialize Sentry's SDK", e);
        }
    }
}

