/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import androidx.annotation.Nullable;
import com.getmati.mati_sdk.sentry.io.sentry.Breadcrumb;
import com.getmati.mati_sdk.sentry.io.sentry.IHub;
import com.getmati.mati_sdk.sentry.io.sentry.Integration;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class TempSensorBreadcrumbsIntegration
implements Integration,
Closeable,
SensorEventListener {
    @NotNull
    private final Context context;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    @Nullable
    SensorManager sensorManager;

    public TempSensorBreadcrumbsIntegration(@NotNull Context context) {
        this.context = Objects.requireNonNull(context, "Context is required");
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.hub = Objects.requireNonNull(hub, "Hub is required");
        this.options = Objects.requireNonNull(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null, "SentryAndroidOptions is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSystemEventsBreadcrumbs enabled: %s", this.options.isEnableSystemEventBreadcrumbs());
        if (this.options.isEnableSystemEventBreadcrumbs()) {
            this.sensorManager = (SensorManager)this.context.getSystemService("sensor");
            if (this.sensorManager != null) {
                Sensor defaultSensor = this.sensorManager.getDefaultSensor(13);
                if (defaultSensor != null) {
                    this.sensorManager.registerListener((SensorEventListener)this, defaultSensor, 3);
                    options.getLogger().log(SentryLevel.DEBUG, "TempSensorBreadcrumbsIntegration installed.", new Object[0]);
                } else {
                    this.options.getLogger().log(SentryLevel.INFO, "TYPE_AMBIENT_TEMPERATURE is not available.", new Object[0]);
                }
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "SENSOR_SERVICE is not available.", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
            this.sensorManager = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "TempSensorBreadcrumbsIntegration removed.", new Object[0]);
            }
        }
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        float[] values = event.values;
        if (values == null || values.length == 0 || values[0] == 0.0f) {
            return;
        }
        if (this.hub != null) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            breadcrumb.setData("action", "TYPE_AMBIENT_TEMPERATURE");
            breadcrumb.setData("accuracy", event.accuracy);
            breadcrumb.setData("timestamp", event.timestamp);
            breadcrumb.setLevel(SentryLevel.INFO);
            breadcrumb.setData("degree", Float.valueOf(event.values[0]));
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

