/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.android.core.util;

import android.os.Looper;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryThread;
import org.jetbrains.annotations.NotNull;

public final class MainThreadChecker {
    private MainThreadChecker() {
    }

    public static boolean isMainThread(@NotNull Thread thread) {
        return MainThreadChecker.isMainThread(thread.getId());
    }

    public static boolean isMainThread() {
        return MainThreadChecker.isMainThread(Thread.currentThread());
    }

    public static boolean isMainThread(@NotNull SentryThread sentryThread) {
        Long threadId = sentryThread.getId();
        return threadId != null && MainThreadChecker.isMainThread(threadId);
    }

    private static boolean isMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }
}

