/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.config;

import com.getmati.mati_sdk.sentry.io.sentry.SystemOutLogger;
import com.getmati.mati_sdk.sentry.io.sentry.config.ClasspathPropertiesLoader;
import com.getmati.mati_sdk.sentry.io.sentry.config.CompositePropertiesProvider;
import com.getmati.mati_sdk.sentry.io.sentry.config.EnvironmentVariablePropertiesProvider;
import com.getmati.mati_sdk.sentry.io.sentry.config.FilesystemPropertiesLoader;
import com.getmati.mati_sdk.sentry.io.sentry.config.PropertiesProvider;
import com.getmati.mati_sdk.sentry.io.sentry.config.SimplePropertiesProvider;
import com.getmati.mati_sdk.sentry.io.sentry.config.SystemPropertyPropertiesProvider;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public final class PropertiesProviderFactory {
    @NotNull
    public static PropertiesProvider create() {
        Properties runDirectoryProperties;
        Properties properties;
        String environmentVariablesLocation;
        Properties properties2;
        SystemOutLogger logger = new SystemOutLogger();
        ArrayList<PropertiesProvider> providers = new ArrayList<PropertiesProvider>();
        providers.add(new SystemPropertyPropertiesProvider());
        providers.add(new EnvironmentVariablePropertiesProvider());
        String systemPropertyLocation = System.getProperty("sentry.properties.file");
        if (systemPropertyLocation != null && (properties2 = new FilesystemPropertiesLoader(systemPropertyLocation, logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(properties2));
        }
        if ((environmentVariablesLocation = System.getenv("SENTRY_PROPERTIES_FILE")) != null && (properties = new FilesystemPropertiesLoader(environmentVariablesLocation, logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(properties));
        }
        if ((properties = new ClasspathPropertiesLoader(logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(properties));
        }
        if ((runDirectoryProperties = new FilesystemPropertiesLoader("sentry.properties", logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(runDirectoryProperties));
        }
        return new CompositePropertiesProvider(providers);
    }
}

