/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.sentry.io.sentry.protocol;

import com.getmati.mati_sdk.sentry.io.sentry.DateUtils;
import com.getmati.mati_sdk.sentry.io.sentry.SentryBaseEvent;
import com.getmati.mati_sdk.sentry.io.sentry.SentryTracer;
import com.getmati.mati_sdk.sentry.io.sentry.Span;
import com.getmati.mati_sdk.sentry.io.sentry.SpanContext;
import com.getmati.mati_sdk.sentry.io.sentry.SpanStatus;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Contexts;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentrySpan;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryTransaction
extends SentryBaseEvent {
    @Nullable
    private String transaction;
    @NotNull
    private final Date startTimestamp;
    @Nullable
    private Date timestamp;
    @NotNull
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    @NotNull
    private final String type = "transaction";

    public SentryTransaction(@NotNull SentryTracer sentryTracer) {
        super(sentryTracer.getEventId());
        Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.startTimestamp = sentryTracer.getStartTimestamp();
        this.timestamp = DateUtils.getCurrentDateTime();
        this.transaction = sentryTracer.getName();
        for (Span span : sentryTracer.getChildren()) {
            this.spans.add(new SentrySpan(span));
        }
        Contexts contexts = this.getContexts();
        for (Map.Entry entry : sentryTracer.getContexts().entrySet()) {
            contexts.put((String)entry.getKey(), entry.getValue());
        }
        contexts.setTrace(sentryTracer.getSpanContext());
        this.setRequest(sentryTracer.getRequest());
    }

    @NotNull
    public List<SentrySpan> getSpans() {
        return this.spans;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getType() {
        return "transaction";
    }

    @Nullable
    public SpanStatus getStatus() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null ? trace.getStatus() : null;
    }

    public boolean isSampled() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null && Boolean.TRUE.equals(trace.getSampled());
    }
}

