/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.ui.camera;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.LayoutRes;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraProvider;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.window.layout.WindowMetricsCalculator;
import com.getmati.mati_sdk.ExtensionsKt;
import com.getmati.mati_sdk.ui.camera.CameraExtensionsKt;
import com.getmati.mati_sdk.ui.camera.CameraPermissionFragment;
import com.getmati.mati_sdk.ui.camera.PhotoCameraFragment;
import com.getmati.mati_sdk.ui.camera.PhotoCameraFragment$takePhoto$;
import com.getmati.mati_sdk.ui.common.KYCBaseFragment;
import com.getmati.mati_sdk.ui.verification.VerificationActivity;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0016\b \u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB\u000f\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0002J\b\u0010/\u001a\u000200H\u0003J\b\u00101\u001a\u000200H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0010H\u0014J\b\u00105\u001a\u000200H\u0004J\b\u00106\u001a\u00020\u001fH\u0002J\b\u00107\u001a\u00020\u001fH\u0002J\b\u00108\u001a\u000200H\u0016J\b\u00109\u001a\u000200H$J\u0010\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020<H$J\u0010\u0010=\u001a\u0002002\u0006\u0010>\u001a\u000203H$J\u0014\u0010?\u001a\u0002002\n\u0010;\u001a\u00060@j\u0002`AH$J\u001a\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\b\u0010G\u001a\u000200H\u0004J\b\u0010H\u001a\u000200H\u0004R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\u00020\u0004X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0005R\u0012\u0010(\u001a\u00020)X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006J"}, d2={"Lcom/getmati/mati_sdk/ui/camera/PhotoCameraFragment;", "Lcom/getmati/mati_sdk/ui/common/KYCBaseFragment;", "Lcom/getmati/mati_sdk/ui/camera/CameraPermissionFragment;", "layoutId", "", "(I)V", "camera", "Landroidx/camera/core/Camera;", "cameraExecutor", "Ljava/util/concurrent/ExecutorService;", "getCameraExecutor", "()Ljava/util/concurrent/ExecutorService;", "setCameraExecutor", "(Ljava/util/concurrent/ExecutorService;)V", "cameraPermissionResult", "Landroidx/activity/result/ActivityResultLauncher;", "", "kotlin.jvm.PlatformType", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "displayId", "displayListener", "com/getmati/mati_sdk/ui/camera/PhotoCameraFragment$displayListener$1", "Lcom/getmati/mati_sdk/ui/camera/PhotoCameraFragment$displayListener$1;", "displayManager", "Landroid/hardware/display/DisplayManager;", "getDisplayManager", "()Landroid/hardware/display/DisplayManager;", "displayManager$delegate", "Lkotlin/Lazy;", "flipHorizontally", "", "getFlipHorizontally", "()Z", "imageCapture", "Landroidx/camera/core/ImageCapture;", "lensFacing", "getLensFacing", "()I", "setLensFacing", "viewFinder", "Landroidx/camera/view/PreviewView;", "getViewFinder", "()Landroidx/camera/view/PreviewView;", "aspectRatio", "width", "height", "bindCameraUseCases", "", "checkPermissionAndOpenCamera", "createFile", "Ljava/io/File;", "ext", "flipCamera", "hasBackCamera", "hasFrontCamera", "onDestroyView", "onFrontBackCamerasNotFound", "onImageCaptureException", "exc", "Landroidx/camera/core/ImageCaptureException;", "onImageSaved", "file", "onUseCaseBindingFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onViewCreated", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "setUpCamera", "takePhoto", "Companion", "mati-sdk_release"})
public abstract class PhotoCameraFragment
extends KYCBaseFragment
implements CameraPermissionFragment {
    private int displayId = -1;
    private Camera camera;
    private ProcessCameraProvider cameraProvider;
    private ImageCapture imageCapture;
    protected ExecutorService cameraExecutor;
    private final Lazy displayManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DisplayManager>(this){
        final /* synthetic */ PhotoCameraFragment this$0;

        @NotNull
        public final DisplayManager invoke() {
            Object object = this.this$0.requireContext().getSystemService("display");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
            }
            return (DisplayManager)object;
        }
        {
            this.this$0 = photoCameraFragment;
            super(0);
        }
    }));
    private final displayListener.1 displayListener = new DisplayManager.DisplayListener(this){
        final /* synthetic */ PhotoCameraFragment this$0;

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            block2: {
                View view = this.this$0.getView();
                if (view == null) break block2;
                View view2 = view;
                boolean bl = false;
                boolean bl2 = false;
                View view3 = view2;
                boolean bl3 = false;
                if (displayId == PhotoCameraFragment.access$getDisplayId$p(this.this$0)) {
                    String string2 = PhotoCameraFragment.access$getTAG$cp();
                    StringBuilder stringBuilder = new StringBuilder().append("Rotation changed: ");
                    View view4 = view3;
                    Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view");
                    Display display = view4.getDisplay();
                    Intrinsics.checkNotNullExpressionValue((Object)display, (String)"view.display");
                    Log.d((String)string2, (String)stringBuilder.append(display.getRotation()).toString());
                    ImageCapture imageCapture = PhotoCameraFragment.access$getImageCapture$p(this.this$0);
                    if (imageCapture != null) {
                        View view5 = this.this$0.requireView();
                        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"requireView()");
                        Display display2 = view5.getDisplay();
                        Intrinsics.checkNotNullExpressionValue((Object)display2, (String)"requireView().display");
                        imageCapture.setTargetRotation(display2.getRotation());
                    }
                }
            }
        }
        {
            this.this$0 = this$0;
        }
    };
    private final ActivityResultLauncher<String> cameraPermissionResult;
    private static final String TAG;
    private static final String FORMAT = "yyyy-MM-dd-HH-mm-ss-SSS";
    private static final double RATIO_4_3_VALUE = 1.3333333333333333;
    private static final double RATIO_16_9_VALUE = 1.7777777777777777;
    private static final String PHOTO_EXTENSION = ".jpg";
    @NotNull
    public static final Companion Companion;

    protected abstract boolean getFlipHorizontally();

    protected abstract void onImageSaved(@NotNull File var1);

    protected abstract void onImageCaptureException(@NotNull ImageCaptureException var1);

    protected abstract int getLensFacing();

    protected abstract void setLensFacing(int var1);

    protected abstract void onUseCaseBindingFailed(@NotNull Exception var1);

    protected abstract void onFrontBackCamerasNotFound();

    @NotNull
    protected abstract PreviewView getViewFinder();

    @NotNull
    protected final ExecutorService getCameraExecutor() {
        ExecutorService executorService = this.cameraExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
        }
        return executorService;
    }

    protected final void setCameraExecutor(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        this.cameraExecutor = executorService;
    }

    private final DisplayManager getDisplayManager() {
        Lazy lazy = this.displayManager$delegate;
        PhotoCameraFragment photoCameraFragment = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DisplayManager)lazy.getValue();
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.cameraExecutor = executorService;
        this.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this.displayListener, null);
        this.getViewFinder().post(new Runnable(this){
            final /* synthetic */ PhotoCameraFragment this$0;

            public final void run() {
                Display display = this.this$0.getViewFinder().getDisplay();
                Intrinsics.checkNotNullExpressionValue((Object)display, (String)"viewFinder.display");
                PhotoCameraFragment.access$setDisplayId$p(this.this$0, display.getDisplayId());
                this.this$0.checkPermissionAndOpenCamera();
            }
            {
                this.this$0 = photoCameraFragment;
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        ExecutorService executorService = this.cameraExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
        }
        executorService.shutdown();
        this.getDisplayManager().unregisterDisplayListener((DisplayManager.DisplayListener)this.displayListener);
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        this.cameraProvider = null;
    }

    protected final void flipCamera() {
        int n;
        switch (this.getLensFacing()) {
            case 0: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.setLensFacing(n);
        this.checkPermissionAndOpenCamera();
    }

    @Override
    public void checkPermissionAndOpenCamera() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        if (ExtensionsKt.hasCameraPermission(context)) {
            this.setUpCamera();
        } else {
            this.cameraPermissionResult.launch((Object)"android.permission.CAMERA");
        }
    }

    protected final void takePhoto() {
        block3: {
            ImageCapture imageCapture = this.imageCapture;
            if (imageCapture == null) break block3;
            ImageCapture imageCapture2 = imageCapture;
            boolean bl = false;
            boolean bl2 = false;
            ImageCapture imageCapture3 = imageCapture2;
            boolean bl3 = false;
            File photoFile = this.createFile(PHOTO_EXTENSION);
            ImageCapture.Metadata metadata2 = new ImageCapture.Metadata();
            boolean bl4 = false;
            boolean bl5 = false;
            ImageCapture.Metadata $this$apply = metadata2;
            boolean bl6 = false;
            $this$apply.setReversedHorizontal(this.getFlipHorizontally());
            ImageCapture.Metadata metadata3 = metadata2;
            ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(photoFile).setMetadata(metadata3).build();
            Intrinsics.checkNotNullExpressionValue((Object)outputFileOptions, (String)"ImageCapture.OutputFileO\u2026\n                .build()");
            ImageCapture.OutputFileOptions outputOptions = outputFileOptions;
            ExecutorService executorService = this.cameraExecutor;
            if (executorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
            }
            imageCapture3.takePicture(outputOptions, (Executor)executorService, new ImageCapture.OnImageSavedCallback(photoFile, this){
                final /* synthetic */ File $photoFile;
                final /* synthetic */ PhotoCameraFragment this$0;
                {
                    this.$photoFile = $captured_local_variable$1;
                    this.this$0 = photoCameraFragment;
                }

                public void onError(@NotNull ImageCaptureException exc) {
                    Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                    this.this$0.onImageCaptureException(exc);
                }

                public void onImageSaved(@NotNull ImageCapture.OutputFileResults output) {
                    Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                    this.this$0.onImageSaved(this.$photoFile);
                }
            });
            if (Build.VERSION.SDK_INT >= 23) {
                View view = this.getView();
                if (view != null) {
                    view.postDelayed(new Runnable(this){
                        final /* synthetic */ PhotoCameraFragment this$0;
                        {
                            this.this$0 = photoCameraFragment;
                        }

                        public final void run() {
                            block1: {
                                View view = this.this$0.getView();
                                if (view != null) {
                                    view.setForeground((Drawable)new ColorDrawable(-1));
                                }
                                View view2 = this.this$0.getView();
                                if (view2 == null) break block1;
                                view2.postDelayed(new Runnable(this){
                                    final /* synthetic */ takePhoto$$inlined$let$lambda$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final void run() {
                                        block0: {
                                            View view = this.this$0.this$0.getView();
                                            if (view == null) break block0;
                                            view.setForeground((Drawable)null);
                                        }
                                    }
                                }, 50L);
                            }
                        }
                    }, 100L);
                }
            }
        }
    }

    protected final void setUpCamera() {
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)this.requireContext());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"ProcessCameraProvider.ge\u2026nstance(requireContext())");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(new Runnable(this, cameraProviderFuture){
            final /* synthetic */ PhotoCameraFragment this$0;
            final /* synthetic */ ListenableFuture $cameraProviderFuture;

            public final void run() {
                Integer lens;
                block5: {
                    block4: {
                        PhotoCameraFragment.access$setCameraProvider$p(this.this$0, (ProcessCameraProvider)this.$cameraProviderFuture.get());
                        ProcessCameraProvider processCameraProvider = PhotoCameraFragment.access$getCameraProvider$p(this.this$0);
                        Integer n = lens = processCameraProvider != null ? Integer.valueOf(CameraExtensionsKt.defineLens((CameraProvider)processCameraProvider, this.this$0.getLensFacing())) : null;
                        if (lens == null) break block4;
                        int n2 = -1;
                        if (lens != n2) break block5;
                    }
                    this.this$0.onFrontBackCamerasNotFound();
                    ProcessCameraProvider processCameraProvider = PhotoCameraFragment.access$getCameraProvider$p(this.this$0);
                    if (processCameraProvider != null) {
                        processCameraProvider.unbindAll();
                    }
                    return;
                }
                this.this$0.setLensFacing(lens);
                PhotoCameraFragment.access$bindCameraUseCases(this.this$0);
            }
            {
                this.this$0 = photoCameraFragment;
                this.$cameraProviderFuture = listenableFuture;
            }
        }, ContextCompat.getMainExecutor((Context)this.requireContext()));
    }

    @SuppressLint(value={"RestrictedApi"})
    private final void bindCameraUseCases() {
        if (this.getActivity() == null) {
            return;
        }
        WindowMetricsCalculator windowMetricsCalculator = WindowMetricsCalculator.Companion.getOrCreate();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        Rect metrics = windowMetricsCalculator.computeCurrentWindowMetrics((Activity)fragmentActivity).getBounds();
        Log.d((String)TAG, (String)("Screen metrics: " + metrics.width() + " x " + metrics.height()));
        int screenAspectRatio = this.aspectRatio(metrics.width(), metrics.height());
        Log.d((String)TAG, (String)("Preview aspect ratio: " + screenAspectRatio));
        Display display = this.getViewFinder().getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"viewFinder.display");
        int rotation = display.getRotation();
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider == null) {
            throw (Throwable)new IllegalStateException("Camera initialization failed.");
        }
        ProcessCameraProvider cameraProvider = processCameraProvider;
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.getLensFacing()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"CameraSelector.Builder()\u2026acing(lensFacing).build()");
        CameraSelector cameraSelector2 = cameraSelector;
        Preview preview = new Preview.Builder().setTargetAspectRatio(screenAspectRatio).setTargetRotation(rotation).build();
        Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"Preview.Builder()\n      \u2026ion)\n            .build()");
        Preview preview2 = preview;
        this.imageCapture = new ImageCapture.Builder().setCaptureMode(1).setTargetAspectRatio(screenAspectRatio).setTargetRotation(rotation).build();
        cameraProvider.unbindAll();
        try {
            this.camera = cameraProvider.bindToLifecycle((LifecycleOwner)this, cameraSelector2, new UseCase[]{(UseCase)preview2, (UseCase)this.imageCapture});
            preview2.setSurfaceProvider(this.getViewFinder().getSurfaceProvider());
        }
        catch (Exception exc) {
            this.onUseCaseBindingFailed(exc);
            Log.e((String)TAG, (String)"Use case binding failed", (Throwable)exc);
        }
    }

    private final int aspectRatio(int width, int height) {
        boolean bl = false;
        bl = false;
        double previewRatio = (double)Math.max(width, height) / (double)Math.min(width, height);
        double d = previewRatio - 1.3333333333333333;
        boolean bl2 = false;
        double d2 = Math.abs(d);
        d = previewRatio - 1.7777777777777777;
        bl2 = false;
        if (d2 <= Math.abs(d)) {
            return 0;
        }
        return 1;
    }

    private final boolean hasBackCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        return processCameraProvider != null ? processCameraProvider.hasCamera(CameraSelector.DEFAULT_BACK_CAMERA) : false;
    }

    private final boolean hasFrontCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        return processCameraProvider != null ? processCameraProvider.hasCamera(CameraSelector.DEFAULT_FRONT_CAMERA) : false;
    }

    @NotNull
    protected File createFile(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        return new File(context.getCacheDir(), new SimpleDateFormat(FORMAT, Locale.US).format(System.currentTimeMillis()) + ext);
    }

    public PhotoCameraFragment(@LayoutRes int layoutId) {
        super(layoutId);
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), (ActivityResultCallback)new ActivityResultCallback<Boolean>(this){
            final /* synthetic */ PhotoCameraFragment this$0;

            public final void onActivityResult(Boolean isGranted) {
                Boolean bl = isGranted;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isGranted");
                if (bl.booleanValue()) {
                    this.this$0.setUpCamera();
                } else {
                    VerificationActivity verificationActivity = PhotoCameraFragment.access$getVerificationActivity$p(this.this$0);
                    Intrinsics.checkNotNull((Object)((Object)verificationActivity));
                    if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)verificationActivity), (String)"android.permission.CAMERA")) {
                        this.this$0.onPermissionDenied(new String[0]);
                    } else {
                        this.this$0.onPermissionPermanentlyDenied("android.permission.CAMERA");
                    }
                }
            }
            {
                this.this$0 = photoCameraFragment;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026        }\n        }\n    }");
        this.cameraPermissionResult = activityResultLauncher;
    }

    static {
        Companion = new Companion(null);
        TAG = PhotoCameraFragment.class.getSimpleName();
    }

    @Override
    public void onPermissionRationaleShown() {
        CameraPermissionFragment.DefaultImpls.onPermissionRationaleShown(this);
    }

    public static final /* synthetic */ int access$getDisplayId$p(PhotoCameraFragment $this) {
        return $this.displayId;
    }

    public static final /* synthetic */ void access$setDisplayId$p(PhotoCameraFragment $this, int n) {
        $this.displayId = n;
    }

    public static final /* synthetic */ ProcessCameraProvider access$getCameraProvider$p(PhotoCameraFragment $this) {
        return $this.cameraProvider;
    }

    public static final /* synthetic */ void access$setCameraProvider$p(PhotoCameraFragment $this, ProcessCameraProvider processCameraProvider) {
        $this.cameraProvider = processCameraProvider;
    }

    public static final /* synthetic */ void access$bindCameraUseCases(PhotoCameraFragment $this) {
        $this.bindCameraUseCases();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ ImageCapture access$getImageCapture$p(PhotoCameraFragment $this) {
        return $this.imageCapture;
    }

    public static final /* synthetic */ void access$setImageCapture$p(PhotoCameraFragment $this, ImageCapture imageCapture) {
        $this.imageCapture = imageCapture;
    }

    public static final /* synthetic */ VerificationActivity access$getVerificationActivity$p(PhotoCameraFragment $this) {
        return $this.getVerificationActivity();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/getmati/mati_sdk/ui/camera/PhotoCameraFragment$Companion;", "", "()V", "FORMAT", "", "PHOTO_EXTENSION", "RATIO_16_9_VALUE", "", "RATIO_4_3_VALUE", "TAG", "kotlin.jvm.PlatformType", "mati-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

